/*
 * Decompiled with CFR 0.152.
 */
package internovi.geometrix.rette;

import internovi.geometrix.rette.Punto;
import internovi.geometrix.rette.Retta;
import internovi.geometrix.rette.SameAngolarCoefficient;

public class RettaFunctions {
    public static Retta rettaPer2Punti(Punto a, Punto b) {
        double m = (b.getY() - a.getY()) / (b.getX() - a.getX());
        return RettaFunctions.rettaPer1PuntiDatoM(a, m);
    }

    public static double distanzaTra2Punti(Punto a, Punto b) {
        return Math.sqrt(Math.pow(b.getY() - a.getY(), 2.0) + Math.pow(b.getX() - a.getX(), 2.0));
    }

    public static Punto puntoDiIntersezioneTra2Rette(Retta retta1, Retta retta2) throws SameAngolarCoefficient {
        if (retta1.getA1() == retta2.getA1()) {
            throw new SameAngolarCoefficient();
        }
        double x = (retta1.getA0() - retta2.getA0()) / (retta2.getA1() - retta1.getA1());
        double y = retta1.getA1() * x + retta1.getA0();
        return new Punto(x, y);
    }

    public static Retta rettaPer1PuntiDatoM(Punto a, double m) {
        double q = a.getY() - m * a.getX();
        return new Retta(m, q);
    }
}

