/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.effectsizes.maintree;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TopicOpenedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.effectsize.valuesdefinition.EffectSizeTreeChildFactory;
import metaanalysis.effectsize.valuesdefinition.GenericContainerNode;
import metaanalysis.effectsize.valuesdefinition.SingleGroupSummaryEffectSizeTreeChildFactory;
import metaanalysis.guiandnodes.studies.OutcomebranchNode;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="EffectsizePanelTopComponent", iconBase="metaanalysis/application/style/effect_size_editor_icon.png", persistenceType=0)
public final class EffectsizePanelTopComponent
extends TopComponent
implements LookupListener,
ExplorerManager.Provider,
PropertyChangeListener {
    private IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
    private ExplorerManager explorerManager = new ExplorerManager();
    private JScrollPane jScrollPane1;
    private Lookup.Result<Node> result = null;

    public EffectsizePanelTopComponent() {
        this.initComponents();
        this.iApplicationManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.iApplicationManager));
        this.setName(NbBundle.getMessage(EffectsizePanelTopComponent.class, (String)"CTL_EffectsizePanelTopComponent"));
        this.setToolTipText(NbBundle.getMessage(EffectsizePanelTopComponent.class, (String)"HINT_EffectsizePanelTopComponent"));
        this.changeTree();
        ActionMap map = this.getActionMap();
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map));
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.jScrollPane1, "Center");
    }

    public void componentOpened() {
        this.result = Utilities.actionsGlobalContext().lookupResult(Node.class);
        this.result.addLookupListener((LookupListener)this);
    }

    public void componentClosed() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void resultChanged(LookupEvent le) {
        Node n;
        Collection allEvents = this.result.allInstances();
        if (allEvents.isEmpty()) {
            return;
        }
        if (!allEvents.isEmpty() && (n = (Node)allEvents.iterator().next()) != null && n instanceof OutcomebranchNode) {
            this.rimbalzaFocus();
        }
    }

    public void changeTree() {
        List allOpenedTopics = this.iApplicationManager.getIDataFunction().getAllOpenedTopics();
        Topic t = null;
        if (!allOpenedTopics.isEmpty()) {
            t = (Topic)allOpenedTopics.get(0);
        }
        if (t != null && t.getTopictype() == Topic.oneGroupSummaryTopicType) {
            this.explorerManager.setRootContext((Node)new GenericContainerNode(this.getEffectSizeRootName(t), Children.create((ChildFactory)new SingleGroupSummaryEffectSizeTreeChildFactory((Object)t), (boolean)true)));
        } else {
            this.explorerManager.setRootContext((Node)new GenericContainerNode(this.getEffectSizeRootName(t), Children.create((ChildFactory)new EffectSizeTreeChildFactory((Object)t), (boolean)true)));
        }
    }

    public String getEffectSizeRootName(Topic t) {
        if (t == null) {
            return NbBundle.getMessage(EffectsizePanelTopComponent.class, (String)"effectsizeroot.name.standard");
        }
        if (t.getTopictype() == 1) {
            return NbBundle.getMessage(EffectsizePanelTopComponent.class, (String)"effectsizeroot.name.standard");
        }
        if (t.getTopictype() == 3) {
            return NbBundle.getMessage(EffectsizePanelTopComponent.class, (String)"effectsizeroot.name.singleGroupSummary");
        }
        return NbBundle.getMessage(EffectsizePanelTopComponent.class, (String)"effectsizeroot.name.standard");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof TopicOpenedEvent) {
            this.changeTree();
        }
    }

    public UndoRedo.Manager getUndoRedo() {
        return this.iApplicationManager.getMainUndoRedoManager();
    }

    private void rimbalzaFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent top = TopComponent.getRegistry().getActivated();
                EffectsizePanelTopComponent.this.requestActive();
                if (top != null) {
                    top.requestActive();
                }
            }
        });
    }
}

