/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.context.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.java.html.BrwsrCtx;
import org.netbeans.html.context.impl.CtxAccssr;
import org.netbeans.html.context.spi.Contexts;

public final class CtxImpl {
    private final List<Bind<?>> techs;
    private final Object[] context;

    public CtxImpl(Object[] context) {
        this(context, new ArrayList());
    }

    private CtxImpl(Object[] context, List<Bind<?>> techs) {
        this.techs = techs;
        this.context = context;
    }

    public static <Tech> Tech find(BrwsrCtx context, Class<Tech> technology) {
        CtxImpl impl = CtxAccssr.getDefault().find(context);
        for (Bind<?> bind : impl.techs) {
            if (technology != ((Bind)bind).clazz) continue;
            return technology.cast(((Bind)bind).impl);
        }
        return null;
    }

    public BrwsrCtx build() {
        Collections.sort(this.techs, new BindCompare());
        List<Bind<?>> arr = Collections.unmodifiableList(this.techs);
        CtxImpl impl = new CtxImpl(this.context, arr);
        BrwsrCtx ctx = CtxAccssr.getDefault().newContext(impl);
        return ctx;
    }

    public <Tech> void register(Class<Tech> type, Tech impl, int priority) {
        this.techs.add(new Bind<Tech>(type, impl, priority));
    }

    private static final class Bind<Tech> {
        private final Class<Tech> clazz;
        private final Tech impl;
        private final int priority;

        public Bind(Class<Tech> clazz, Tech impl, int priority) {
            this.clazz = clazz;
            this.impl = impl;
            this.priority = priority;
        }

        public String toString() {
            return "Bind{clazz=" + this.clazz + "@" + this.clazz.getClassLoader() + ", impl=" + this.impl + ", priority=" + this.priority + '}';
        }
    }

    private final class BindCompare
    implements Comparator<Bind<?>> {
        private BindCompare() {
        }

        boolean isPrefered(Bind<?> b) {
            Class<?> implClazz = ((Bind)b).impl.getClass();
            Contexts.Id id = implClazz.getAnnotation(Contexts.Id.class);
            if (id == null) {
                return false;
            }
            for (String v : id.value()) {
                for (Object c : CtxImpl.this.context) {
                    if (!v.equals(c)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(Bind<?> o1, Bind<?> o2) {
            boolean p2;
            boolean p1 = this.isPrefered(o1);
            if (p1 != (p2 = this.isPrefered(o2))) {
                return p1 ? -1 : 1;
            }
            if (((Bind)o1).priority != ((Bind)o2).priority) {
                return ((Bind)o1).priority - ((Bind)o2).priority;
            }
            return ((Bind)o1).clazz.getName().compareTo(((Bind)o2).clazz.getName());
        }
    }
}

