/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.global.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import metaanalysis.actions.models.RemoveTopicAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Topic;
import metaanalysis.util.backup.BackupException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class RemoveTopicFromDatabase
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        Topic topic = null;
        try {
            IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
            List allOpenedTopics = iApplicationManager.getIDataFunction().getAllOpenedTopics();
            if (allOpenedTopics.isEmpty()) {
                throw new BackupException(NbBundle.getMessage(BackupException.class, (String)"topic.notopened"));
            }
            topic = (Topic)allOpenedTopics.get(0);
            if (TuliTuliTools.doYouWantDoABigMistake((String)NbBundle.getMessage(RemoveTopicFromDatabase.class, (String)"remove.descriptionDialog"))) {
                iApplicationManager.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveTopicAA(topic, iApplicationManager));
                TuliTuliTools.whatAMessage((String)NbBundle.getMessage(RemoveTopicFromDatabase.class, (String)"topic.removed"));
                Frame f = WindowManager.getDefault().getMainWindow();
                f.setTitle("ProMeta");
            }
        }
        catch (Exception ex) {
            TuliTuliTools.whatAnError((String)ex.getMessage());
        }
    }
}

