/*
 * Decompiled with CFR 0.152.
 */
package cip.integrator;

import cip.integrator.FromAnalysisToCipFileAction;
import cip.integrator.IForestPlotInputWrapper;
import forestplot.api.ForestPlotException;
import forestplot.api.ForestPlotRunner;
import forestplot.api.IScale;
import forestplot.api.PlotInputData;
import formattazione.numeri.MyNumberFormatter;
import gui.alerts.GuiAlerts;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CipWidget
extends JPanel {
    private final IForestPlotInputWrapper iForestPlotInputWrapper;
    private final boolean exporter;
    private final MyNumberFormatter myNumberFormatter;
    private JButton plotButton;
    private JButton saveButton;

    public CipWidget(IForestPlotInputWrapper iForestPlotInputWrapper, boolean exporter, MyNumberFormatter myNumberFormatter) {
        this.initComponents();
        this.iForestPlotInputWrapper = iForestPlotInputWrapper;
        this.exporter = exporter;
        this.setOpaque(false);
        this.myNumberFormatter = myNumberFormatter;
    }

    private void initComponents() {
        this.plotButton = new JButton();
        this.saveButton = new JButton();
        this.plotButton.setIcon(new ImageIcon(this.getClass().getResource("/cip/integrator/plotcippy24.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.plotButton, (String)NbBundle.getMessage(CipWidget.class, (String)"CipWidget.plotButton.text"));
        this.plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CipWidget.this.plotButtonActionPerformed(evt);
            }
        });
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/cip/integrator/savecippy24.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)NbBundle.getMessage(CipWidget.class, (String)"CipWidget.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CipWidget.this.saveButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.plotButton).addGap(18, 18, 18).addComponent(this.saveButton).addContainerGap(71, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.plotButton).addComponent(this.saveButton)).addContainerGap(8, Short.MAX_VALUE)));
    }

    private void plotButtonActionPerformed(ActionEvent evt) {
        try {
            ForestPlotRunner.openNewFrame((PlotInputData)this.getiForestPlotInputWrapper().getPlotInputData(), (IScale)this.getiForestPlotInputWrapper().getIScale(), (int)500, (int)300, (MyNumberFormatter)this.myNumberFormatter);
        }
        catch (ForestPlotException ex) {
            GuiAlerts.whatAnError((String)ex.getMessage());
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        new FromAnalysisToCipFileAction(this.iForestPlotInputWrapper).run();
    }

    public IForestPlotInputWrapper getiForestPlotInputWrapper() {
        return this.iForestPlotInputWrapper;
    }

    public boolean isExporter() {
        return this.exporter;
    }
}

