/*
 * Decompiled with CFR 0.152.
 */
package cip.integrator;

import cip.integrator.IForestPlotInputWrapper;
import forestplot.api.BloccoDiRighe;
import forestplot.api.ColoumnDescripotrsFactory;
import forestplot.api.DataEntryRow;
import forestplot.api.FisherScale;
import forestplot.api.IScale;
import forestplot.api.LinearScale;
import forestplot.api.LogScale;
import forestplot.api.OverallRow;
import forestplot.api.PlotInputData;
import forestplot.api.ScaleDataInputErrorException;
import formattazione.numeri.MyNumberFormatter;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.AnalysisDataBeanList;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysisList;
import metaanalysis.core.analysis.impl.OneStudyRemoveAnalysis;
import metaanalysis.effectsizes.models.ESVTools;
import org.openide.util.NbBundle;

public final class ForestPlotInputWrapper
implements IForestPlotInputWrapper {
    protected PlotInputData plotInputData = new PlotInputData();
    private final MyNumberFormatter myNumberFormatter;
    protected IScale iScale;

    @Override
    public PlotInputData getPlotInputData() {
        return this.plotInputData;
    }

    public void setPlotInputData(PlotInputData plotInputData) {
        this.plotInputData = plotInputData;
    }

    @Override
    public IScale getIScale() {
        return this.iScale;
    }

    public void setIScale(IScale iScale) {
        this.iScale = iScale;
    }

    public ForestPlotInputWrapper(AnalysisDataBeanList rows, boolean fixed, String effectSizeType, MyNumberFormatter myNumberFormatter) throws ScaleDataInputErrorException {
        this.myNumberFormatter = myNumberFormatter;
        BloccoDiRighe b = new BloccoDiRighe();
        for (AnalysisDataBean row : rows) {
            if (fixed) {
                b.add((Object)new OverallRow(row.getName(), row.getFixedWeight(), row.getPressEffectSize().getEffectSize().doubleValue(), row.getPressEffectSize().getStandardError(), row.getPressEffectSize().getVariance(), row.getPressEffectSize().getLowerLimit(), row.getPressEffectSize().getUpperLimit(), row.getPressEffectSize().getZValue(), row.getPressEffectSize().getPValue(), row.getSampleSize().getSampleSize(), row.getSampleSize().getGroupASize(), row.getSampleSize().getGroupBSize(), row.getSampleSize().getNotSignedSize()));
                continue;
            }
            b.add((Object)new OverallRow(row.getName(), row.getRandomWeight(), row.getPressEffectSize().getEffectSize().doubleValue(), row.getPressEffectSize().getStandardError(), row.getPressEffectSize().getVariance(), row.getPressEffectSize().getLowerLimit(), row.getPressEffectSize().getUpperLimit(), row.getPressEffectSize().getZValue(), row.getPressEffectSize().getPValue(), row.getSampleSize().getSampleSize(), row.getSampleSize().getGroupASize(), row.getSampleSize().getGroupBSize(), row.getSampleSize().getNotSignedSize()));
        }
        this.plotInputData.getBlocchiRighe().add((Object)b);
        this.setUp(effectSizeType);
    }

    public ForestPlotInputWrapper(FixedAndRandomAnalysisList fixedAndRandomAnalyses, boolean fixed, String effectSizeType, MyNumberFormatter myNumberFormatter) throws ScaleDataInputErrorException {
        this.myNumberFormatter = myNumberFormatter;
        for (FixedAndRandomAnalysis fixedAndRandom : fixedAndRandomAnalyses) {
            BloccoDiRighe b = new BloccoDiRighe();
            for (AnalysisDataBean row : fixedAndRandom.getDatarows()) {
                if (fixed) {
                    b.add((Object)new DataEntryRow(row.getName(), row.getFixedWeight(), row.getPressEffectSize().getEffectSize().doubleValue(), row.getPressEffectSize().getStandardError(), row.getPressEffectSize().getVariance(), row.getPressEffectSize().getLowerLimit(), row.getPressEffectSize().getUpperLimit(), row.getPressEffectSize().getZValue(), row.getPressEffectSize().getPValue(), row.getSampleSize().getSampleSize(), row.getSampleSize().getGroupASize(), row.getSampleSize().getGroupBSize(), row.getSampleSize().getNotSignedSize()));
                    continue;
                }
                b.add((Object)new DataEntryRow(row.getName(), row.getRandomWeight(), row.getPressEffectSize().getEffectSize().doubleValue(), row.getPressEffectSize().getStandardError(), row.getPressEffectSize().getVariance(), row.getPressEffectSize().getLowerLimit(), row.getPressEffectSize().getUpperLimit(), row.getPressEffectSize().getZValue(), row.getPressEffectSize().getPValue(), row.getSampleSize().getSampleSize(), row.getSampleSize().getGroupASize(), row.getSampleSize().getGroupBSize(), row.getSampleSize().getNotSignedSize()));
            }
            if (fixed) {
                b.add((Object)new OverallRow(fixedAndRandom.getFixedOverall().getName(), 100.0, fixedAndRandom.getFixedOverall().getPressEffectSize().getEffectSize().doubleValue(), fixedAndRandom.getFixedOverall().getPressEffectSize().getStandardError(), fixedAndRandom.getFixedOverall().getPressEffectSize().getVariance(), fixedAndRandom.getFixedOverall().getPressEffectSize().getLowerLimit(), fixedAndRandom.getFixedOverall().getPressEffectSize().getUpperLimit(), fixedAndRandom.getFixedOverall().getPressEffectSize().getZValue(), fixedAndRandom.getFixedOverall().getPressEffectSize().getPValue(), fixedAndRandom.getFixedOverall().getSampleSize().getSampleSize(), fixedAndRandom.getFixedOverall().getSampleSize().getGroupASize(), fixedAndRandom.getFixedOverall().getSampleSize().getGroupBSize(), fixedAndRandom.getFixedOverall().getSampleSize().getNotSignedSize()));
            } else {
                b.add((Object)new OverallRow(fixedAndRandom.getRandomOverall().getName(), 100.0, fixedAndRandom.getRandomOverall().getPressEffectSize().getEffectSize().doubleValue(), fixedAndRandom.getRandomOverall().getPressEffectSize().getStandardError(), fixedAndRandom.getRandomOverall().getPressEffectSize().getVariance(), fixedAndRandom.getRandomOverall().getPressEffectSize().getLowerLimit(), fixedAndRandom.getRandomOverall().getPressEffectSize().getUpperLimit(), fixedAndRandom.getRandomOverall().getPressEffectSize().getZValue(), fixedAndRandom.getRandomOverall().getPressEffectSize().getPValue(), fixedAndRandom.getRandomOverall().getSampleSize().getSampleSize(), fixedAndRandom.getRandomOverall().getSampleSize().getGroupASize(), fixedAndRandom.getRandomOverall().getSampleSize().getGroupBSize(), fixedAndRandom.getRandomOverall().getSampleSize().getNotSignedSize()));
            }
            this.plotInputData.getBlocchiRighe().add((Object)b);
            this.setUp(effectSizeType);
        }
    }

    public ForestPlotInputWrapper(FixedAndRandomAnalysis fixedAndRandom, boolean fixed, String effectSizeType, MyNumberFormatter myNumberFormatter) throws ScaleDataInputErrorException {
        this.myNumberFormatter = myNumberFormatter;
        BloccoDiRighe b = new BloccoDiRighe();
        for (AnalysisDataBean row : fixedAndRandom.getDatarows()) {
            if (fixed) {
                b.add((Object)new DataEntryRow(row.getName(), row.getFixedWeight(), row.getPressEffectSize().getEffectSize().doubleValue(), row.getPressEffectSize().getStandardError(), row.getPressEffectSize().getVariance(), row.getPressEffectSize().getLowerLimit(), row.getPressEffectSize().getUpperLimit(), row.getPressEffectSize().getZValue(), row.getPressEffectSize().getPValue(), row.getSampleSize().getSampleSize(), row.getSampleSize().getGroupASize(), row.getSampleSize().getGroupBSize(), row.getSampleSize().getNotSignedSize()));
                continue;
            }
            b.add((Object)new DataEntryRow(row.getName(), row.getRandomWeight(), row.getPressEffectSize().getEffectSize().doubleValue(), row.getPressEffectSize().getStandardError(), row.getPressEffectSize().getVariance(), row.getPressEffectSize().getLowerLimit(), row.getPressEffectSize().getUpperLimit(), row.getPressEffectSize().getZValue(), row.getPressEffectSize().getPValue(), row.getSampleSize().getSampleSize(), row.getSampleSize().getGroupASize(), row.getSampleSize().getGroupBSize(), row.getSampleSize().getNotSignedSize()));
        }
        if (fixed) {
            b.add((Object)new OverallRow(fixedAndRandom.getFixedOverall().getName(), 100.0, fixedAndRandom.getFixedOverall().getPressEffectSize().getEffectSize().doubleValue(), fixedAndRandom.getFixedOverall().getPressEffectSize().getStandardError(), fixedAndRandom.getFixedOverall().getPressEffectSize().getVariance(), fixedAndRandom.getFixedOverall().getPressEffectSize().getLowerLimit(), fixedAndRandom.getFixedOverall().getPressEffectSize().getUpperLimit(), fixedAndRandom.getFixedOverall().getPressEffectSize().getZValue(), fixedAndRandom.getFixedOverall().getPressEffectSize().getPValue(), fixedAndRandom.getFixedOverall().getSampleSize().getSampleSize(), fixedAndRandom.getFixedOverall().getSampleSize().getGroupASize(), fixedAndRandom.getFixedOverall().getSampleSize().getGroupBSize(), fixedAndRandom.getFixedOverall().getSampleSize().getNotSignedSize()));
        } else {
            b.add((Object)new OverallRow(fixedAndRandom.getRandomOverall().getName(), 100.0, fixedAndRandom.getRandomOverall().getPressEffectSize().getEffectSize().doubleValue(), fixedAndRandom.getRandomOverall().getPressEffectSize().getStandardError(), fixedAndRandom.getRandomOverall().getPressEffectSize().getVariance(), fixedAndRandom.getRandomOverall().getPressEffectSize().getLowerLimit(), fixedAndRandom.getRandomOverall().getPressEffectSize().getUpperLimit(), fixedAndRandom.getRandomOverall().getPressEffectSize().getZValue(), fixedAndRandom.getRandomOverall().getPressEffectSize().getPValue(), fixedAndRandom.getRandomOverall().getSampleSize().getSampleSize(), fixedAndRandom.getRandomOverall().getSampleSize().getGroupASize(), fixedAndRandom.getRandomOverall().getSampleSize().getGroupBSize(), fixedAndRandom.getRandomOverall().getSampleSize().getNotSignedSize()));
        }
        this.plotInputData.getBlocchiRighe().add((Object)b);
        this.setUp(effectSizeType);
    }

    public ForestPlotInputWrapper(OneStudyRemoveAnalysis osrAnalysis, boolean fixed, String effectSizeType, MyNumberFormatter myNumberFormatter) throws ScaleDataInputErrorException {
        this.myNumberFormatter = myNumberFormatter;
        BloccoDiRighe b = new BloccoDiRighe();
        if (fixed) {
            for (AnalysisDataBean row : osrAnalysis.getFixedRows()) {
                b.add((Object)new OverallRow(row.getName(), row.getFixedWeight(), row.getPressEffectSize().getEffectSize().doubleValue(), row.getPressEffectSize().getStandardError(), row.getPressEffectSize().getVariance(), row.getPressEffectSize().getLowerLimit(), row.getPressEffectSize().getUpperLimit(), row.getPressEffectSize().getZValue(), row.getPressEffectSize().getPValue(), row.getSampleSize().getSampleSize(), row.getSampleSize().getGroupASize(), row.getSampleSize().getGroupBSize(), row.getSampleSize().getNotSignedSize()));
            }
        } else {
            for (AnalysisDataBean row : osrAnalysis.getRandomRows()) {
                b.add((Object)new OverallRow(row.getName(), row.getRandomWeight(), row.getPressEffectSize().getEffectSize().doubleValue(), row.getPressEffectSize().getStandardError(), row.getPressEffectSize().getVariance(), row.getPressEffectSize().getLowerLimit(), row.getPressEffectSize().getUpperLimit(), row.getPressEffectSize().getZValue(), row.getPressEffectSize().getPValue(), row.getSampleSize().getSampleSize(), row.getSampleSize().getGroupASize(), row.getSampleSize().getGroupBSize(), row.getSampleSize().getNotSignedSize()));
            }
        }
        this.plotInputData.getBlocchiRighe().add((Object)b);
        this.setUp(effectSizeType);
    }

    private void setUp(String effectSizeType) throws ScaleDataInputErrorException {
        this.plotInputData.setZeroLineValue((double)ESVTools.getNullValue((String)effectSizeType));
        this.plotInputData.setColonne(ColoumnDescripotrsFactory.generateStandardMetaAnalisyDescriptors((MyNumberFormatter)this.myNumberFormatter));
        this.plotInputData.setUp();
        String preferrredScale = ESVTools.getPreferrredScale((String)effectSizeType);
        if (preferrredScale.equals(NbBundle.getMessage(IScale.class, (String)"scale.linear.name"))) {
            this.setIScale((IScale)new LinearScale(this.getPlotInputData()));
        } else if (preferrredScale.equals(NbBundle.getMessage(IScale.class, (String)"scale.log.name"))) {
            this.setIScale((IScale)new LogScale(this.getPlotInputData()));
        } else if (preferrredScale.equals(NbBundle.getMessage(IScale.class, (String)"scale.fisher.name"))) {
            this.setIScale((IScale)new FisherScale(this.getPlotInputData()));
        } else {
            this.setIScale((IScale)new LinearScale(this.getPlotInputData()));
        }
    }
}

