/*
 * Decompiled with CFR 0.152.
 */
package cip.integrator;

import cip.integrator.IForestPlotInputWrapper;
import effectsizeplot.api.IEffectSizeSource;
import effectsizeplot.core.CipEditorWindow;
import effectsizeplot.core.CipFileReaderAndWriter;
import effectsizeplot.core.CipFileWrapper;
import effectsizeplot.input.directeffectsize.DirectESRowExtended;
import effectsizeplot.input.directeffectsize.DirectESSourceBeanExtended;
import filemanager.tools.FileManagerException;
import filemanager.tools.FileTools;
import filemanager.tools.IFileSourceReaderAndWriter;
import filemanager.tools.IMultiFileManager;
import filemanager.tools.ISourceWrapper;
import filemanager.tools.SourceFileNotSupported;
import forestplot.api.IForestPlotRow;
import gui.alerts.GuiAlerts;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.util.Lookup;

public class FromAnalysisToCipFileAction {
    private List<DirectESRowExtended> rows = new ArrayList<DirectESRowExtended>();
    private final IForestPlotInputWrapper wp;

    public FromAnalysisToCipFileAction(IForestPlotInputWrapper wp) {
        this.wp = wp;
        for (IForestPlotRow r : wp.getPlotInputData().getAllRows()) {
            DirectESRowExtended fromIForestPlotRowToDirectESRowExtended = DirectESSourceBeanExtended.fromIForestPlotRowToDirectESRowExtended((IForestPlotRow)r);
            if (fromIForestPlotRowToDirectESRowExtended == null) continue;
            this.rows.add(fromIForestPlotRowToDirectESRowExtended);
        }
    }

    public void run() {
        DirectESSourceBeanExtended source = new DirectESSourceBeanExtended();
        for (int i = 0; i < this.rows.size(); ++i) {
            source.setRighe(i, this.rows.get(i));
        }
        CipFileReaderAndWriter cipFileReaderAndWriter = new CipFileReaderAndWriter();
        String chooseLocationToSave = FileTools.chooseLocationToSave((IFileSourceReaderAndWriter)cipFileReaderAndWriter);
        if (chooseLocationToSave != null) {
            CipFileWrapper tmp = new CipFileWrapper((IEffectSizeSource)source, chooseLocationToSave);
            try {
                cipFileReaderAndWriter.saveSource((ISourceWrapper)tmp, chooseLocationToSave);
            }
            catch (SourceFileNotSupported ex) {
                GuiAlerts.whatAnError((String)"FILE NOT SAVED");
                return;
            }
        } else {
            return;
        }
        IMultiFileManager t = (IMultiFileManager)Lookup.getDefault().lookup(IMultiFileManager.class);
        try {
            t.addFile(chooseLocationToSave);
        }
        catch (FileManagerException ex) {
            GuiAlerts.whatAnError((String)("FILE NOT OPENED\n" + ex.getMessage()));
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CipEditorWindow tc = new CipEditorWindow();
                tc.open();
                tc.requestActive();
            }
        });
    }
}

