/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis;

import metaanalysis.core.analysis.SubgroupHeterogeneityStatistic;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.openide.util.Exceptions;

public class HeterogeneityStatistic
extends SubgroupHeterogeneityStatistic {
    protected double t;
    protected double t2;
    protected double i2;

    public HeterogeneityStatistic(double q, int df, double p, double t, double t2, double i2) {
        super(q, df, p);
        this.t = t;
        this.t2 = t2;
        this.i2 = i2;
    }

    public HeterogeneityStatistic(String name, double q, int df, double p, double t, double t2, double i2) {
        super(name, q, df, p);
        this.t = t;
        this.t2 = t2;
        this.i2 = i2;
    }

    public HeterogeneityStatistic(String name, FixedAndRandomAnalysis analysis) {
        this(name, analysis, false);
    }

    public HeterogeneityStatistic(String name, FixedAndRandomAnalysis analysis, boolean random) {
        super(name);
        double i2H;
        int dfH = analysis.getDatarows().size() - 1;
        if (dfH <= 0) {
            this.t2 = 0.0;
            this.q = 0.0;
            this.df = 0;
            this.t = Math.sqrt(this.t2);
            this.i2 = 0.0;
            this.p = 1.0;
            return;
        }
        double qH = 0.0;
        for (AnalysisDataBean row : analysis.getDatarows()) {
            if (random) {
                qH += row.getRawRandomWeight() * Math.pow(row.getCalculationEffectSize().getEffectSize() - analysis.getFixedOverall().getCalculationEffectSize().getEffectSize(), 2.0);
                continue;
            }
            qH += row.getRawFixedWeight() * Math.pow(row.getCalculationEffectSize().getEffectSize() - analysis.getFixedOverall().getCalculationEffectSize().getEffectSize(), 2.0);
        }
        double t2H = (qH - (double)dfH) / analysis.getVariableC();
        if (t2H < 0.0) {
            t2H = 0.0;
        }
        if ((i2H = (qH - (double)dfH) / qH * 100.0) < 0.0) {
            i2H = 0.0;
        }
        ChiSquaredDistributionImpl chiSquaredDistribution = new ChiSquaredDistributionImpl((double)dfH);
        this.t2 = t2H;
        this.q = qH;
        this.df = dfH;
        this.t = Math.sqrt(this.t2);
        this.i2 = i2H;
        try {
            this.p = 1.0 - chiSquaredDistribution.cumulativeProbability(qH);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public double getT() {
        return this.t;
    }

    public double getT2() {
        return this.t2;
    }

    public double getI2() {
        return this.i2;
    }
}

