/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis;

import metaanalysis.analysis.models.IDataEntryRow;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.effectsizes.models.ESVTools;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;

public abstract class TreeRow
implements IDataEntryRow {
    protected Study study;
    protected Subgroup subgroup;
    protected Comparison comparison;
    protected Integer timepoint;
    protected Outcome outcome;
    protected IEffectSizeResults iEffectSizeResults;
    protected ISampleSizeValue sampleSizeValue;
    protected Outcomebranch outcomebranch;
    protected boolean combined = false;
    protected Timepointbranch timepointbranch;
    protected Comparisonbranch comparisonbranch;
    protected Subgroupbranch subgroupbranch;

    public TreeRow(Study study, Subgroup subgroup, Comparison comparison, Integer timepoint, Outcome outcome, IEffectSizeResults iEffectSizeResults, ISampleSizeValue sampleSizeValue, Outcomebranch outcomebranch, Timepointbranch timepointbranch, Comparisonbranch comparisonbranch, Subgroupbranch subgroupbranch) {
        this.study = study;
        this.subgroup = subgroup;
        this.comparison = comparison;
        this.timepoint = timepoint;
        this.outcome = outcome;
        this.iEffectSizeResults = iEffectSizeResults;
        this.sampleSizeValue = sampleSizeValue;
        this.outcomebranch = outcomebranch;
        this.timepointbranch = timepointbranch;
        this.comparisonbranch = comparisonbranch;
        this.subgroupbranch = subgroupbranch;
    }

    public TreeRow(Study study, Subgroupbranch subgroupbranch, Comparisonbranch comparisonbranch, Timepointbranch timepointbranch, Outcomebranch outcomebranch, String effectsizeResultsType, IApplicationManager iApplicationManager) {
        this.study = study;
        this.outcomebranch = outcomebranch;
        this.timepointbranch = timepointbranch;
        this.comparisonbranch = comparisonbranch;
        this.subgroupbranch = subgroupbranch;
        this.costruisci(effectsizeResultsType, iApplicationManager);
    }

    public TreeRow(Outcomebranch outcomebranch, String effectsizeResultsType, IApplicationManager iApplicationManager) {
        this.outcomebranch = outcomebranch;
        this.timepointbranch = iApplicationManager.getIDataFunction().getTimepointbranch(outcomebranch.getTimepointbranchId().longValue());
        this.comparisonbranch = iApplicationManager.getIDataFunction().getComparisonbranch(this.timepointbranch.getComparisonbranchId().longValue());
        this.subgroupbranch = iApplicationManager.getIDataFunction().getSubgroupbranch(this.comparisonbranch.getSubgroupbranchId().longValue());
        this.study = iApplicationManager.getIDataFunction().getStudy(this.subgroupbranch.getStudyId().longValue());
        this.costruisci(effectsizeResultsType, iApplicationManager);
    }

    public TreeRow() {
    }

    private void costruisci(String effectsizeResultsType, IApplicationManager iApplicationManager) {
        this.outcome = iApplicationManager.getIDataFunction().getOutcome(this.outcomebranch.getOutcomeId().intValue());
        this.timepoint = this.timepointbranch.getTimepointId();
        this.comparison = iApplicationManager.getIDataFunction().getComparison(this.comparisonbranch.getComparisonId().intValue());
        this.subgroup = iApplicationManager.getIDataFunction().getSubgroup(this.subgroupbranch.getSubgroupId().intValue());
        IEffectSizeValue toESV = ESVTools.toESV((String)this.outcomebranch.getEffectsizevalue());
        this.iEffectSizeResults = toESV.getRightResults(effectsizeResultsType);
        this.sampleSizeValue = toESV.getISampleSizeValue();
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(Outcome outcome) {
        this.outcome = outcome;
    }

    public Subgroup getSubgroup() {
        return this.subgroup;
    }

    public void setSubgroup(Subgroup subgroup) {
        this.subgroup = subgroup;
    }

    public Integer getTimepoint() {
        return this.timepoint;
    }

    public void setTimepoint(Integer timepoint) {
        this.timepoint = timepoint;
    }

    public ISampleSizeValue getSampleSizeValue() {
        return this.sampleSizeValue;
    }

    public void setSampleSizeValue(ISampleSizeValue sampleSizeValue) {
        this.sampleSizeValue = sampleSizeValue;
    }

    public IEffectSizeResults getIEffectSizeResults() {
        return this.iEffectSizeResults;
    }

    public void setiEffectSizeResults(IEffectSizeResults iEffectSizeResults) {
        this.iEffectSizeResults = iEffectSizeResults;
    }

    public Outcomebranch getOutcomebranch() {
        return this.outcomebranch;
    }

    public void setOutcomebranch(Outcomebranch outcomebranch) {
        this.outcomebranch = outcomebranch;
    }

    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    public Comparisonbranch getComparisonbranch() {
        return this.comparisonbranch;
    }

    public void setComparisonbranch(Comparisonbranch comparisonbranch) {
        this.comparisonbranch = comparisonbranch;
    }

    public Subgroupbranch getSubgroupbranch() {
        return this.subgroupbranch;
    }

    public void setSubgroupbranch(Subgroupbranch subgroupbranch) {
        this.subgroupbranch = subgroupbranch;
    }

    public Timepointbranch getTimepointbranch() {
        return this.timepointbranch;
    }

    public void setTimepointbranch(Timepointbranch timepointbranch) {
        this.timepointbranch = timepointbranch;
    }

    public String getName() {
        String tmp = this.study.getName();
        if (this.subgroup != null && this.subgroup.getId() != -1) {
            tmp = tmp + "/" + this.subgroup.getName();
        }
        if (this.comparison != null && this.comparison.getId() != -1) {
            tmp = tmp + "/" + this.comparison.getName();
        }
        if (this.timepoint != null && this.timepoint != -1) {
            tmp = tmp + "/" + this.timepoint.toString();
        }
        if (this.outcome != null && this.outcome.getId() != -1) {
            tmp = tmp + "/" + this.outcome.getName();
        }
        return tmp;
    }

    public boolean hasTheSameKeyUntilTimepointbranch(TreeRow row) {
        if (!(this.getStudy() != null && row.getStudy() != null || this.getStudy() == null && row.getStudy() == null)) {
            return false;
        }
        if (!(this.getSubgroup() != null && row.getSubgroup() != null || this.getSubgroup() == null && row.getSubgroup() == null)) {
            return false;
        }
        if (!(this.getComparison() != null && row.getComparison() != null || this.getComparison() == null && row.getComparison() == null)) {
            return false;
        }
        return this.getStudy() == row.getStudy() && this.getSubgroup().getId() == row.getSubgroup().getId() && this.getComparison().getId() == row.getComparison().getId() && this.getTimepoint() == row.getTimepoint();
    }

    public boolean hasTheSameKeyUntilTimepointbranch(TreeRow row, boolean subgroupCombined, boolean comparisonCombined, boolean timepointCombined) {
        if (!(this.getStudy() != null && row.getStudy() != null || this.getStudy() == null && row.getStudy() == null)) {
            return false;
        }
        if (!subgroupCombined) {
            if (!(this.getSubgroup() != null && row.getSubgroup() != null || this.getSubgroup() == null && row.getSubgroup() == null)) {
                return false;
            }
            if (this.getSubgroup().getId() != row.getSubgroup().getId()) {
                return false;
            }
        }
        if (!comparisonCombined) {
            if (!(this.getComparison() != null && row.getComparison() != null || this.getComparison() == null && row.getComparison() == null)) {
                return false;
            }
            if (this.getComparison().getId() != row.getComparison().getId()) {
                return false;
            }
        }
        if (!timepointCombined) {
            if (!(this.getTimepoint() != null && row.getTimepoint() != null || this.getTimepoint() == null && row.getTimepoint() == null)) {
                return false;
            }
            if (this.getTimepoint() != row.getTimepoint()) {
                return false;
            }
        }
        return this.getStudy() == row.getStudy();
    }

    public boolean hasTheSameKey(TreeRow row) {
        if (!this.hasTheSameKeyUntilTimepointbranch(row)) {
            return false;
        }
        if (!(this.getOutcome() != null && row.getOutcome() != null || this.getOutcome() == null && row.getOutcome() == null)) {
            return false;
        }
        return this.getOutcome().getId() == row.getOutcome().getId();
    }

    public boolean isCombined() {
        return this.combined;
    }

    public void setIEffectSizeResults(IEffectSizeResults iEffectSizeResults) {
        this.iEffectSizeResults = iEffectSizeResults;
    }
}

