/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.beggspublicationbias;

import formattazione.numeri.MyNumberFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.core.analysis.beggspublicationbias.BeggsAnalysisBeanESComparator;
import metaanalysis.core.analysis.beggspublicationbias.BeggsAnalysisBeanVarianceComparator;
import metaanalysis.core.analysis.beggspublicationbias.BeggsAnalysisRowBean;
import metaanalysis.core.analysis.beggspublicationbias.BeggsPublicationBiasBean;
import metaanalysis.core.analysis.beggspublicationbias.BeggsReportPanel;
import metaanalysis.core.analysis.impl.AAnalysis;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public class BeggsAnalysis
extends AAnalysis
implements IAnalysis {
    private BeggsPublicationBiasBean beggsPublicationBiasBean = new BeggsPublicationBiasBean();
    private final MyNumberFormatter myNumberFormatter;
    List<BeggsAnalysisRowBean> beggsRows = new ArrayList<BeggsAnalysisRowBean>();

    public final BeggsPublicationBiasBean getBeggsPublicationBiasBean() {
        return this.beggsPublicationBiasBean;
    }

    public void setBeggsPublicationBiasBean(BeggsPublicationBiasBean beggsPublicationBiasBean) {
        this.beggsPublicationBiasBean = beggsPublicationBiasBean;
    }

    public BeggsAnalysis(List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval, MyNumberFormatter myNumberFormatter) throws AnalysisException {
        super("", rows, pressEffectSizeType, confidenceInterval);
        int i;
        this.myNumberFormatter = myNumberFormatter;
        FixedAndRandomAnalysis an = new FixedAndRandomAnalysis("", rows, pressEffectSizeType, confidenceInterval);
        an.runFixed();
        for (AnalysisDataBean row : this.datarows) {
            this.beggsRows.add(new BeggsAnalysisRowBean(row));
        }
        double inversoSommatoriaPesi = 0.0;
        for (BeggsAnalysisRowBean row : this.beggsRows) {
            inversoSommatoriaPesi += row.getRow().getRawFixedWeight();
        }
        inversoSommatoriaPesi = 1.0 / inversoSommatoriaPesi;
        for (BeggsAnalysisRowBean row : this.beggsRows) {
            row.setVarianzaStabilizzata(row.getRow().getCalculationEffectSize().getVariance() - inversoSommatoriaPesi);
        }
        for (BeggsAnalysisRowBean row : this.beggsRows) {
            double num = row.getRow().getCalculationEffectSize().getEffectSize() - an.getFixedOverall().getCalculationEffectSize().getEffectSize();
            double den = Math.sqrt(row.getVarianzaStabilizzata());
            row.setEffectSizeStabilizzato(num / den);
        }
        Collections.sort(this.beggsRows, new BeggsAnalysisBeanESComparator());
        int rank = 1;
        for (i = 0; i < this.beggsRows.size(); ++i) {
            if (i == 0) {
                this.beggsRows.get(i).setEsRank(rank);
                continue;
            }
            if (this.beggsRows.get(i).getEffectSizeStabilizzato() == this.beggsRows.get(i - 1).getEffectSizeStabilizzato()) {
                this.beggsRows.get(i).setEsRank(rank);
                continue;
            }
            this.beggsRows.get(i).setEsRank(++rank);
        }
        Collections.sort(this.beggsRows, new BeggsAnalysisBeanVarianceComparator());
        rank = 1;
        for (i = 0; i < this.beggsRows.size(); ++i) {
            if (i == 0) {
                this.beggsRows.get(i).setVarianceRank(rank);
                continue;
            }
            if (this.beggsRows.get(i).getVarianzaStabilizzata() == this.beggsRows.get(i - 1).getVarianzaStabilizzata()) {
                this.beggsRows.get(i).setVarianceRank(rank);
                continue;
            }
            this.beggsRows.get(i).setVarianceRank(++rank);
        }
        for (BeggsAnalysisRowBean row : this.beggsRows) {
            row.setVarianzaStabilizzata(row.getRow().getCalculationEffectSize().getVariance() - inversoSommatoriaPesi);
        }
        int concordanti = 0;
        int discordanti = 0;
        int accoppiati = 0;
        for (int i2 = 0; i2 < this.beggsRows.size(); ++i2) {
            for (int j = i2 + 1; j < this.beggsRows.size(); ++j) {
                int confronto = this.beggsRows.get(i2).confronta(this.beggsRows.get(j));
                if (confronto == BeggsAnalysisRowBean.accoppiato) {
                    ++accoppiati;
                    continue;
                }
                if (confronto == BeggsAnalysisRowBean.concordante) {
                    ++concordanti;
                    continue;
                }
                ++discordanti;
            }
        }
        double den = 1.0 * (double)this.beggsRows.size() * (double)(this.beggsRows.size() - 1) * (double)(2 * this.beggsRows.size() + 5) / 18.0;
        this.getBeggsPublicationBiasBean().setZetaValue(1.0 * (double)(concordanti - discordanti) / Math.sqrt(den));
        NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
        try {
            this.getBeggsPublicationBiasBean().setSignificance2Tails((1.0 - normalDistribution.cumulativeProbability(Math.abs(this.getBeggsPublicationBiasBean().getZetaValue()))) * 2.0);
        }
        catch (MathException mathException) {
            // empty catch block
        }
    }

    public JPanel getGuiReport(boolean panelTitle) {
        return new BeggsReportPanel(this.beggsPublicationBiasBean, this.myNumberFormatter);
    }
}

