/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.beggspublicationbias;

import metaanalysis.core.analysis.impl.AnalysisDataBean;

public class BeggsAnalysisRowBean {
    private AnalysisDataBean row;
    private double effectSizeStabilizzato;
    private double esRank;
    private double varianceRank;
    private double varianzaStabilizzata;
    public static int concordante = 1;
    public static int discordante = 2;
    public static int accoppiato = 3;

    public BeggsAnalysisRowBean(AnalysisDataBean row) {
        this.row = row;
    }

    public BeggsAnalysisRowBean(AnalysisDataBean row, double correctedEffectSize, double esRank, double varianceRank, double varianzaStabilizzata) {
        this.row = row;
        this.effectSizeStabilizzato = correctedEffectSize;
        this.esRank = esRank;
        this.varianceRank = varianceRank;
        this.varianzaStabilizzata = varianzaStabilizzata;
    }

    public BeggsAnalysisRowBean() {
    }

    public AnalysisDataBean getRow() {
        return this.row;
    }

    public void setRow(AnalysisDataBean row) {
        this.row = row;
    }

    public double getEffectSizeStabilizzato() {
        return this.effectSizeStabilizzato;
    }

    public void setEffectSizeStabilizzato(double correctedEffectSize) {
        this.effectSizeStabilizzato = correctedEffectSize;
    }

    public double getEsRank() {
        return this.esRank;
    }

    public void setEsRank(double esRank) {
        this.esRank = esRank;
    }

    public double getVarianceRank() {
        return this.varianceRank;
    }

    public void setVarianceRank(double varianceRank) {
        this.varianceRank = varianceRank;
    }

    public double getVarianzaStabilizzata() {
        return this.varianzaStabilizzata;
    }

    public void setVarianzaStabilizzata(double varianzaStabilizzata) {
        this.varianzaStabilizzata = varianzaStabilizzata;
    }

    public int confronta(BeggsAnalysisRowBean bean) {
        if (this.getEsRank() == bean.getEsRank() || this.varianceRank == bean.varianceRank) {
            return accoppiato;
        }
        if (this.getEsRank() > bean.getEsRank() && this.varianceRank > bean.varianceRank || this.getEsRank() < bean.getEsRank() && this.varianceRank < bean.varianceRank) {
            return concordante;
        }
        return discordante;
    }
}

