/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.eggerpublicationpias;

import formattazione.numeri.MyNumberFormatter;
import java.util.List;
import javax.swing.JPanel;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.analysis.eggerpublicationpias.EggerReportPanel;
import metaanalysis.core.analysis.impl.AAnalysis;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.apache.commons.math.stat.regression.SimpleRegression;

public class EggerAnalysis
extends AAnalysis
implements IAnalysis {
    private final SimpleRegression regression = new SimpleRegression();
    private final MyNumberFormatter myNumberFormatter;

    public EggerAnalysis(List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval, MyNumberFormatter myNumberFormatter) throws AnalysisException {
        super("", rows, pressEffectSizeType, confidenceInterval);
        for (AnalysisDataBean row : this.getDatarows()) {
            this.regression.addData(1.0 / row.getCalculationEffectSize().getStandardError(), row.getCalculationEffectSize().getEffectSize() / row.getCalculationEffectSize().getStandardError());
        }
        this.myNumberFormatter = myNumberFormatter;
    }

    public JPanel getGuiReport(boolean panelTitle) {
        TDistributionImpl t = new TDistributionImpl((double)(this.getDf() - 1));
        double p = 0.0;
        try {
            p = 2.0 * (1.0 - t.cumulativeProbability(Math.abs(this.regression.getIntercept() / this.regression.getInterceptStdErr())));
        }
        catch (MathException ex) {
            TuliTuliTools.whatAnError((String)ex.getMessage());
        }
        return new EggerReportPanel(this.regression.getIntercept(), this.regression.getIntercept() / this.regression.getInterceptStdErr(), p, this.myNumberFormatter);
    }
}

