/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.failsafenpublicationbias;

import java.util.List;
import javax.swing.JPanel;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.core.analysis.failsafenpublicationbias.FailSafeNReportPanel;
import metaanalysis.core.analysis.impl.AAnalysis;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.DataRowsHandler;

public class FailSafeNAnalysis
extends AAnalysis
implements IAnalysis {
    public static final double zValueForPValue_05_2tailed = 1.95996;
    protected long nValue;
    protected long rosenthalValue;

    public long getNValue() {
        return this.nValue;
    }

    public long getRosenthalValue() {
        return this.rosenthalValue;
    }

    public boolean isSecurityInterval() {
        return this.nValue > this.rosenthalValue;
    }

    public FailSafeNAnalysis(List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval) throws AnalysisException {
        super("", rows, pressEffectSizeType, confidenceInterval);
        this.nValue = Math.round(Math.pow(DataRowsHandler.sommaZValues(this.datarows) / 1.95996, 2.0) - (double)(this.getDf() + 1));
        if (this.nValue < 0L) {
            this.nValue = 0L;
        }
        this.rosenthalValue = (this.getDf() + 1) * 5 + 10;
    }

    public JPanel getGuiReport(boolean panelTitle) {
        return new FailSafeNReportPanel(this.nValue, this.rosenthalValue, this.isSecurityInterval());
    }
}

