/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.util.ArrayList;
import java.util.List;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.DataRowsHandler;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Project;
import org.openide.util.NbBundle;

public abstract class AAnalysis {
    protected List<AnalysisDataBean> datarows = new ArrayList<AnalysisDataBean>();
    protected int df;
    protected String name;
    protected String pressEffectSizeType;
    protected String calculationEffectSizeType;
    private double confidenceInterval;

    public AAnalysis(String name, List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval) throws AnalysisException {
        this.name = name;
        this.df = rows.size() - 1;
        if (this.df < 0) {
            throw new AnalysisException(NbBundle.getMessage(AAnalysis.class, (String)"Error.pochiStudi", (Object)(this.df + 1)));
        }
        for (AnalysisDataBean row : rows) {
            this.datarows.add(row);
        }
        this.pressEffectSizeType = pressEffectSizeType;
        this.calculationEffectSizeType = AnalysisFilter.findCalculationEffectSizeType((String)pressEffectSizeType);
        this.confidenceInterval = confidenceInterval;
    }

    public AAnalysis(String name, Project project, IApplicationManager iApplicationManager) throws AnalysisException {
        this.name = name;
        this.datarows = DataRowsHandler.extractFilteredDataRows(project.getTopicId(), AnalysisFilter.readAnalysisFilter((String)project.getFilter()), iApplicationManager, true);
        this.df = this.datarows.size() - 1;
        if (this.df < 0) {
            throw new AnalysisException(NbBundle.getMessage(AAnalysis.class, (String)"Error.pochiStudi", (Object)(this.df + 1)));
        }
        AnalysisFilter filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        this.confidenceInterval = filter.getConfidenceInterval();
        this.pressEffectSizeType = filter.getPressEffectSizeType();
        this.calculationEffectSizeType = filter.getCalculationEffectSizeType();
    }

    public void filterByModerator(Moderator moderator) throws AnalysisException {
        this.datarows = DataRowsHandler.filterModeratorRowsNotNull(this.datarows, moderator);
        this.df = this.datarows.size() - 1;
        if (this.df < 0) {
            throw new AnalysisException(NbBundle.getMessage(AAnalysis.class, (String)"Error.pochiStudi", (Object)(this.df + 1)));
        }
    }

    public List<AnalysisDataBean> getDatarows() {
        return this.datarows;
    }

    public void setDatarows(List<AnalysisDataBean> datarows) {
        this.datarows = datarows;
    }

    public int getDf() {
        return this.df;
    }

    public int getK() {
        return this.getDf() + 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPressEffectSizeType() {
        return this.pressEffectSizeType;
    }

    public void setPressEffectSizeType(String pressEffectSizeType) {
        this.pressEffectSizeType = pressEffectSizeType;
    }

    public String getCalculationEffectSizeType() {
        return this.calculationEffectSizeType;
    }

    public void setCalculationEffectSizeType(String calculationEffectSizeType) {
        this.calculationEffectSizeType = calculationEffectSizeType;
    }

    public double getConfidenceInterval() {
        return this.confidenceInterval;
    }
}

