/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.application.tools.SpeedyCopy;
import metaanalysis.core.analysis.impl.AnalysisDataBeanKey;
import metaanalysis.core.analysis.impl.ModeratorsTable;
import metaanalysis.core.analysis.impl.NullEffectSizeException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.effectsizes.models.ESRConversions;
import metaanalysis.effectsizes.models.ESVTools;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.effectsizes.models.ISampleSizeValue;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AnalysisDataBean
implements SpeedyCopy<AnalysisDataBean> {
    protected String name;
    protected ISampleSizeValue sampleSize;
    protected IEffectSizeResults calculationEffectSize;
    protected IEffectSizeResults pressEffectSize;
    protected String pressEffectSizeType;
    protected double fixedWeight;
    protected double randomWeight;
    protected double rawFixedWeight;
    protected double rawRandomWeight;
    protected double fixedResiduo;
    protected double fixedResiduoPValue;
    protected double randomResiduo;
    protected double randomResiduoPValue;
    protected AnalysisDataBeanKey rowKey = new AnalysisDataBeanKey();
    protected ModeratorsTable moderatorsTable = new ModeratorsTable();
    private int numberOfStudies = 0;

    public AnalysisDataBean(String name, ISampleSizeValue sampleSize, IEffectSizeResults calculationEffectSize, IEffectSizeResults pressEffectSize, String pressEffectSizeType) {
        this.name = name;
        this.sampleSize = sampleSize;
        this.calculationEffectSize = calculationEffectSize;
        this.pressEffectSize = pressEffectSize;
        this.pressEffectSizeType = pressEffectSizeType;
        this.fillRawFixedWeight();
    }

    public AnalysisDataBean() {
    }

    public AnalysisDataBean(String name, ISampleSizeValue sampleSize, IEffectSizeResults calculationEffectSize, String pressEffectSizeType, double confidenceInterval) throws AnalysisException {
        if (calculationEffectSize == null) {
            throw new NullEffectSizeException(name);
        }
        this.name = name;
        this.sampleSize = sampleSize;
        this.calculationEffectSize = calculationEffectSize;
        this.pressEffectSizeType = pressEffectSizeType;
        this.pressConversion(confidenceInterval);
        this.fillRawFixedWeight();
    }

    public AnalysisDataBean(String name, String pressEffectSizeType, IEffectSizeValue value) throws NullEffectSizeException {
        this.name = name;
        this.pressEffectSizeType = pressEffectSizeType;
        this.sampleSize = value.getISampleSizeValue();
        this.calculationEffectSize = value.getRightResults(this.pressEffectSizeType);
        this.calculationAssign(value);
        if (this.getCalculationEffectSize() == null || this.getPressEffectSize() == null) {
            throw new NullEffectSizeException(this.getName());
        }
        this.fillRawFixedWeight();
    }

    public AnalysisDataBean(String pressEffectSizeType, Study study, Subgroupbranch subgroupbranch, Comparisonbranch comparisonbranch, Timepointbranch timepointbranch, Outcomebranch outcomebranch, IApplicationManager iApplicationManager) throws AnalysisException {
        this.rowKey.setStudy(study);
        this.rowKey.setSubgroupbranch(subgroupbranch);
        this.rowKey.setSubgroup(iApplicationManager.getIDataFunction().getSubgroup(subgroupbranch.getSubgroupId().intValue()));
        this.rowKey.setComparisonbranch(comparisonbranch);
        this.rowKey.setComparison(iApplicationManager.getIDataFunction().getComparison(comparisonbranch.getComparisonId().intValue()));
        this.rowKey.setTimepointbranch(timepointbranch);
        this.rowKey.setTimepoint(timepointbranch.getTimepointId());
        this.rowKey.setOutcomebranch(outcomebranch);
        this.rowKey.setOutcome(iApplicationManager.getIDataFunction().getOutcome(outcomebranch.getOutcomeId().intValue()));
        this.elaborateName();
        this.moderatorsTable = new ModeratorsTable(outcomebranch, iApplicationManager);
        IEffectSizeValue value = ESVTools.toESV((String)outcomebranch.getEffectsizevalue());
        if (value == null) {
            throw new NullEffectSizeException(this.getName());
        }
        this.pressEffectSizeType = pressEffectSizeType;
        this.sampleSize = value.getISampleSizeValue();
        this.pressEffectSize = value.getRightResults(this.pressEffectSizeType);
        this.calculationAssign(value);
        if (this.getCalculationEffectSize() == null || this.getPressEffectSize() == null) {
            throw new NullEffectSizeException(this.getName());
        }
        this.fillRawFixedWeight();
    }

    public final void elaborateName() {
        this.name = this.rowKey.elaborateName();
    }

    public AnalysisDataBean(String name, AnalysisDataBeanKey rowKey, ISampleSizeValue sampleSize, IEffectSizeResults calculationEffectSize, IEffectSizeResults pressEffectSize, String pressEffectSizeType, double fixedWeight, double randomWeight, double rawFixedWeight, double rawRandomWeight, double fixedResiduo, double fixedResiduoPValue, double randomResiduo, double randomResiduoPValue, ModeratorsTable moderatorsTable) throws NullEffectSizeException {
        if (calculationEffectSize == null) {
            throw new NullEffectSizeException(name);
        }
        this.rowKey = rowKey;
        this.name = name;
        this.sampleSize = sampleSize;
        this.calculationEffectSize = calculationEffectSize;
        this.pressEffectSize = pressEffectSize;
        this.pressEffectSizeType = pressEffectSizeType;
        this.fixedWeight = fixedWeight;
        this.randomWeight = randomWeight;
        this.rawFixedWeight = rawFixedWeight;
        this.rawRandomWeight = rawRandomWeight;
        this.fixedResiduo = fixedResiduo;
        this.fixedResiduoPValue = fixedResiduoPValue;
        this.randomResiduo = randomResiduo;
        this.randomResiduoPValue = randomResiduoPValue;
        this.moderatorsTable = moderatorsTable;
    }

    public AnalysisDataBean duplicate() {
        try {
            AnalysisDataBean analysisDataBean = new AnalysisDataBean(this.name, this.rowKey.duplicate(), this.sampleSize, this.calculationEffectSize, this.pressEffectSize, this.pressEffectSizeType, this.fixedWeight, this.randomWeight, this.rawFixedWeight, this.rawRandomWeight, this.fixedResiduo, this.fixedResiduoPValue, this.randomResiduo, this.randomResiduoPValue, this.moderatorsTable);
            analysisDataBean.setNumberOfStudies(this.numberOfStudies);
            return analysisDataBean;
        }
        catch (NullEffectSizeException ex) {
            Exceptions.printStackTrace((Throwable)((Object)ex));
            return null;
        }
    }

    public void copyFrom(AnalysisDataBean obj) {
        this.rowKey = obj.getRowKey().duplicate();
        this.name = obj.name;
        this.sampleSize = (ISampleSizeValue)obj.sampleSize.duplicate();
        this.calculationEffectSize = (IEffectSizeResults)obj.calculationEffectSize.duplicate();
        this.pressEffectSize = (IEffectSizeResults)obj.pressEffectSize.duplicate();
        this.pressEffectSizeType = obj.pressEffectSizeType;
        this.fixedWeight = obj.fixedWeight;
        this.randomWeight = obj.randomWeight;
        this.rawFixedWeight = obj.rawFixedWeight;
        this.rawRandomWeight = obj.rawRandomWeight;
        this.fixedResiduo = obj.fixedResiduo;
        this.fixedResiduoPValue = obj.fixedResiduoPValue;
        this.randomResiduo = obj.randomResiduo;
        this.randomResiduoPValue = obj.randomResiduoPValue;
    }

    public final void fillRawFixedWeight() {
        this.setRawFixedWeight(1.0 / this.getCalculationEffectSize().getVariance());
    }

    public final void fillRawRandomWeight(double tSquare) {
        this.setRawRandomWeight(1.0 / (this.getCalculationEffectSize().getVariance() + tSquare));
    }

    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ISampleSizeValue getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(ISampleSizeValue sampleSize) {
        this.sampleSize = sampleSize;
    }

    public final IEffectSizeResults getCalculationEffectSize() {
        return this.calculationEffectSize;
    }

    public void setCalculationEffectSize(IEffectSizeResults calculationEffectSize) {
        this.calculationEffectSize = calculationEffectSize;
    }

    public final IEffectSizeResults getPressEffectSize() {
        return this.pressEffectSize;
    }

    public void setPressEffectSize(IEffectSizeResults pressEffectSize) {
        this.pressEffectSize = pressEffectSize;
    }

    public String getPressEffectSizeType() {
        return this.pressEffectSizeType;
    }

    public void setPressEffectSizeType(String pressEffectSizeType) {
        this.pressEffectSizeType = pressEffectSizeType;
    }

    public double getFixedWeight() {
        return this.fixedWeight;
    }

    public void setFixedWeight(double fixedWeight) {
        this.fixedWeight = fixedWeight;
    }

    public double getRandomWeight() {
        return this.randomWeight;
    }

    public void setRandomWeight(double randomWeight) {
        this.randomWeight = randomWeight;
    }

    public double getRawFixedWeight() {
        return this.rawFixedWeight;
    }

    public void setRawFixedWeight(double rawFixedWeight) {
        this.rawFixedWeight = rawFixedWeight;
    }

    public double getRawRandomWeight() {
        return this.rawRandomWeight;
    }

    public void setRawRandomWeight(double rawRandomWeight) {
        this.rawRandomWeight = rawRandomWeight;
    }

    public double getFixedResiduo() {
        return this.fixedResiduo;
    }

    public void setFixedResiduo(double fixedResiduo) {
        this.fixedResiduo = fixedResiduo;
    }

    public double getFixedResiduoPValue() {
        return this.fixedResiduoPValue;
    }

    public void setFixedResiduoPValue(double fixedResiduoPValue) {
        this.fixedResiduoPValue = fixedResiduoPValue;
    }

    public double getRandomResiduo() {
        return this.randomResiduo;
    }

    public void setRandomResiduo(double randomResiduo) {
        this.randomResiduo = randomResiduo;
    }

    public double getRandomResiduoPValue() {
        return this.randomResiduoPValue;
    }

    public void setRandomResiduoPValue(double randomResiduoPValue) {
        this.randomResiduoPValue = randomResiduoPValue;
    }

    public AnalysisDataBeanKey getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(AnalysisDataBeanKey rowKey) {
        this.rowKey = rowKey;
    }

    public final void pressConversion(double confidenceInterval) {
        if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel"))) {
            this.setPressEffectSize((IEffectSizeResults)ESRConversions.fromLogOddsRatioToOddsRatio((IEffectSizeResults)this.calculationEffectSize, (double)confidenceInterval));
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"correlationLabel"))) {
            this.setPressEffectSize((IEffectSizeResults)ESRConversions.fromFisherZToCorrelation((IEffectSizeResults)this.calculationEffectSize, (double)confidenceInterval));
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hazardRatioLabel"))) {
            this.setPressEffectSize(ESRConversions.convertFromLogToNormal((IEffectSizeResults)this.calculationEffectSize));
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskRatioLabel"))) {
            this.setPressEffectSize(ESRConversions.convertFromLogToNormal((IEffectSizeResults)this.calculationEffectSize));
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"petoOddsRatioLabel"))) {
            this.setPressEffectSize(ESRConversions.convertFromLogToNormal((IEffectSizeResults)this.calculationEffectSize));
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel"))) {
            this.setPressEffectSize(ESRConversions.convertFromLogToNormal((IEffectSizeResults)this.calculationEffectSize));
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.eventRate"))) {
            this.setPressEffectSize(ESRConversions.convertFromLogRateEventToNormalRateEvent((IEffectSizeResults)this.calculationEffectSize));
        } else {
            this.setPressEffectSize(this.getCalculationEffectSize());
        }
    }

    public final void calculationAssign(IEffectSizeValue value) {
        if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oddsRatioLabel"))) {
            this.setCalculationEffectSize((IEffectSizeResults)value.getLogOddsRatioEffectSizeResults());
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"correlationLabel"))) {
            this.setCalculationEffectSize((IEffectSizeResults)value.getFishersZEffectSizeResults());
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"hazardRatioLabel"))) {
            this.setCalculationEffectSize((IEffectSizeResults)value.getLogHazardRatioEffectSizeResults());
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"riskRatioLabel"))) {
            this.setCalculationEffectSize((IEffectSizeResults)value.getLogRiskRatioEffectSizeResults());
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"petoOddsRatioLabel"))) {
            this.setCalculationEffectSize((IEffectSizeResults)value.getLogPetoOddsRatioEffectSizeResults());
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"rateRatioLabel"))) {
            this.setCalculationEffectSize((IEffectSizeResults)value.getLogRateRatioEffectSizeResults());
        } else if (this.pressEffectSizeType.equals(NbBundle.getMessage(IEffectSizeValue.class, (String)"oneGroupSummary.eventRate"))) {
            this.setCalculationEffectSize((IEffectSizeResults)value.getOneGroupSummaryLogEventRateEffectSizeResults());
        } else {
            this.setCalculationEffectSize(this.getPressEffectSize());
        }
    }

    public boolean hasTheSameKey(AnalysisDataBean row) {
        return this.getRowKey().isEqual(row.getRowKey());
    }

    public ModeratorsTable getModeratorsTable() {
        return this.moderatorsTable;
    }

    public void setModeratorsTable(ModeratorsTable moderatorsTable) {
        this.moderatorsTable = moderatorsTable;
    }

    public int getNumberOfStudies() {
        return this.numberOfStudies;
    }

    public void setNumberOfStudies(int numberOfStudies) {
        this.numberOfStudies = numberOfStudies;
    }

    public String toDebugString() {
        return "+ " + this.getName() + "\n getRawFixedWeight" + this.getRawFixedWeight() + "\n getFixedWeight" + this.getFixedWeight() + "\n getRawRandomWeight" + this.getRawRandomWeight() + "\n getRandomWeight" + this.getRandomWeight() + "\n calculationEffectSize" + this.calculationEffectSize.getEffectSize() + "\n calculationEffectSizegetLowerLimit" + this.calculationEffectSize.getLowerLimit() + "\n calculationEffectSizegetUpperLimit" + this.calculationEffectSize.getUpperLimit() + "\n pressEffectSize" + this.pressEffectSize.getEffectSize() + "\n pressEffectSizegetLowerLimit" + this.pressEffectSize.getLowerLimit() + "\n pressEffectSizegetUpperLimit" + this.pressEffectSize.getUpperLimit() + "\n getRawFixedWeight" + this.getRawFixedWeight();
    }
}

