/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import metaanalysis.application.tools.SpeedyCopy;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.core.persistence.Timepointbranch;

public class AnalysisDataBeanKey
implements SpeedyCopy<AnalysisDataBeanKey> {
    protected Study study;
    protected Subgroup subgroup;
    protected Comparison comparison;
    protected Integer timepoint;
    protected Outcome outcome;
    protected Outcomebranch outcomebranch;
    protected Timepointbranch timepointbranch;
    protected Comparisonbranch comparisonbranch;
    protected Subgroupbranch subgroupbranch;

    public AnalysisDataBeanKey() {
    }

    public AnalysisDataBeanKey(Study study, Subgroup subgroup, Comparison comparison, Integer timepoint, Outcome outcome, Outcomebranch outcomebranch, Timepointbranch timepointbranch, Comparisonbranch comparisonbranch, Subgroupbranch subgroupbranch) {
        this.study = study;
        this.subgroup = subgroup;
        this.comparison = comparison;
        this.timepoint = timepoint;
        this.outcome = outcome;
        this.outcomebranch = outcomebranch;
        this.timepointbranch = timepointbranch;
        this.comparisonbranch = comparisonbranch;
        this.subgroupbranch = subgroupbranch;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
    }

    public Comparisonbranch getComparisonbranch() {
        return this.comparisonbranch;
    }

    public void setComparisonbranch(Comparisonbranch comparisonbranch) {
        this.comparisonbranch = comparisonbranch;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(Outcome outcome) {
        this.outcome = outcome;
    }

    public Outcomebranch getOutcomebranch() {
        return this.outcomebranch;
    }

    public void setOutcomebranch(Outcomebranch outcomebranch) {
        this.outcomebranch = outcomebranch;
    }

    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    public Subgroup getSubgroup() {
        return this.subgroup;
    }

    public void setSubgroup(Subgroup subgroup) {
        this.subgroup = subgroup;
    }

    public Subgroupbranch getSubgroupbranch() {
        return this.subgroupbranch;
    }

    public void setSubgroupbranch(Subgroupbranch subgroupbranch) {
        this.subgroupbranch = subgroupbranch;
    }

    public Integer getTimepoint() {
        return this.timepoint;
    }

    public void setTimepoint(Integer timepoint) {
        this.timepoint = timepoint;
    }

    public Timepointbranch getTimepointbranch() {
        return this.timepointbranch;
    }

    public void setTimepointbranch(Timepointbranch timepointbranch) {
        this.timepointbranch = timepointbranch;
    }

    public AnalysisDataBeanKey duplicate() {
        return new AnalysisDataBeanKey(this.study, this.subgroup, this.comparison, this.timepoint, this.outcome, this.outcomebranch, this.timepointbranch, this.comparisonbranch, this.subgroupbranch);
    }

    public void copyFrom(AnalysisDataBeanKey obj) {
        this.study = obj.study;
        this.subgroup = obj.subgroup;
        this.comparison = obj.comparison;
        this.timepoint = obj.timepoint;
        this.outcome = obj.outcome;
        this.outcomebranch = obj.outcomebranch;
        this.timepointbranch = obj.timepointbranch;
        this.comparisonbranch = obj.comparisonbranch;
        this.subgroupbranch = obj.subgroupbranch;
    }

    public void resetOutcome() {
        this.outcome = null;
        this.outcomebranch = null;
    }

    public void resetSubgroup() {
        this.subgroup = null;
        this.subgroupbranch = null;
    }

    public void resetComparison() {
        this.comparison = null;
        this.comparisonbranch = null;
    }

    public void resetTimepoint() {
        this.timepoint = null;
        this.timepointbranch = null;
    }

    public final String elaborateName() {
        String tmp = "";
        if (this.study != null) {
            tmp = tmp + this.study.getName();
        }
        if (this.subgroup != null && this.subgroup.getId() != -1) {
            tmp = tmp + "/" + this.subgroup.getName();
        }
        if (this.comparison != null && this.comparison.getId() != -1) {
            tmp = tmp + "/" + this.comparison.getName();
        }
        if (this.timepoint != null && this.timepoint != -1) {
            tmp = tmp + "/W" + (this.timepoint + 1);
        }
        if (this.outcome != null && this.outcome.getId() != -1) {
            tmp = tmp + "/" + this.outcome.getName();
        }
        return tmp;
    }

    public boolean isEqual(AnalysisDataBeanKey rowKey) {
        if (this.getStudy() == null || rowKey.getStudy() == null ? this.getStudy() != null || rowKey.getStudy() != null : this.getStudy().getId() != rowKey.getStudy().getId()) {
            return false;
        }
        if (this.getSubgroup() == null || rowKey.getSubgroup() == null ? this.getSubgroup() != null || rowKey.getSubgroup() != null : this.getSubgroup().getId() != rowKey.getSubgroup().getId()) {
            return false;
        }
        if (this.getComparison() == null || rowKey.getComparison() == null ? this.getComparison() != null || rowKey.getComparison() != null : this.getComparison().getId() != rowKey.getComparison().getId()) {
            return false;
        }
        if (this.getTimepoint() == null || rowKey.getTimepoint() == null ? this.getTimepoint() != null || rowKey.getTimepoint() != null : this.getTimepoint() != rowKey.getTimepoint()) {
            return false;
        }
        return !(this.getOutcome() == null || rowKey.getOutcome() == null ? this.getOutcome() != null || rowKey.getOutcome() != null : this.getOutcome().getId() != rowKey.getOutcome().getId());
    }

    public String toString() {
        return "study: " + this.getStudy() + "\n subgroupbranch: " + this.getSubgroupbranch() + "\n subgroup: " + this.getSubgroup() + "\n comparisonbranch: " + this.getComparisonbranch() + "\n comparison: " + this.getComparison() + "\n timepointbranch: " + this.getTimepointbranch() + "\n timepoint: " + this.getTimepoint() + "\n outcomebranch: " + this.getOutcomebranch() + "\n outcome: " + this.getOutcome();
    }
}

