/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import cip.integrator.CipWidget;
import cip.integrator.ForestPlotInputWrapper;
import forestplot.api.ScaleDataInputErrorException;
import formattazione.numeri.MyNumberFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.impl.AAnalysis;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.AnalysisDataBeanList;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.analysis.panels.TablesGenerator;
import metaanalysis.core.analysis.panels.TitleSapce;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Project;
import org.openide.util.NbBundle;

public class CumulativeAnalysis
extends AAnalysis {
    private final Comparator<AnalysisDataBean> comparator;
    private MyNumberFormatter myNumberFormatter;
    protected AnalysisDataBeanList fixedRows = new AnalysisDataBeanList();
    protected AnalysisDataBeanList randomRows = new AnalysisDataBeanList();

    public CumulativeAnalysis(Project project, IApplicationManager applicationEventWorker, Comparator<AnalysisDataBean> comparator) throws AnalysisException {
        super(NbBundle.getMessage(AAnalysis.class, (String)"analysis.cumulative.name"), project, applicationEventWorker);
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        this.comparator = comparator;
        this.run();
    }

    public CumulativeAnalysis(String name, List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval, Comparator<AnalysisDataBean> comparator, MyNumberFormatter myNumberFormatter) throws AnalysisException {
        super(name, rows, pressEffectSizeType, confidenceInterval);
        this.myNumberFormatter = myNumberFormatter;
        this.comparator = comparator;
        this.run();
    }

    private void run() throws AnalysisException {
        this.df = this.datarows.size() - 1;
        if (this.df < 0) {
            throw new AnalysisException(NbBundle.getMessage(FixedAndRandomAnalysis.class, (String)"Error.pochiStudi", (Object)(this.df + 1)));
        }
        Collections.sort(this.getDatarows(), this.comparator);
        ArrayList<AnalysisDataBean> righe = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean row : this.getDatarows()) {
            righe.add(row);
            FixedAndRandomAnalysis fra = new FixedAndRandomAnalysis("", righe, this.pressEffectSizeType, this.getConfidenceInterval());
            fra.runFixed();
            fra.runRandom();
            fra.getFixedOverall().setName(row.getName());
            fra.getFixedOverall().setModeratorsTable(row.getModeratorsTable());
            fra.getRandomOverall().setName(row.getName());
            fra.getRandomOverall().setModeratorsTable(row.getModeratorsTable());
            this.fixedRows.add(fra.getFixedOverall());
            this.randomRows.add(fra.getRandomOverall());
        }
    }

    public AnalysisDataBeanList getFixedRows() {
        return this.fixedRows;
    }

    public void setFixedRows(AnalysisDataBeanList fixedRows) {
        this.fixedRows = fixedRows;
    }

    public AnalysisDataBeanList getRandomRows() {
        return this.randomRows;
    }

    public void setRandomRows(AnalysisDataBeanList randomRows) {
        this.randomRows = randomRows;
    }

    public JPanel getGuiReport(boolean panelTitle, boolean fixedModel, boolean randomModel, double zeroLine, Moderator moderator) {
        JPanel tmp;
        JTable t;
        ForestPlotInputWrapper forestPlotInputWrapper;
        JPanel xxx = new JPanel();
        xxx.setLayout(new BoxLayout(xxx, 1));
        xxx.setBackground(StyleProvider.panelBackground);
        if (fixedModel) {
            if (panelTitle) {
                try {
                    forestPlotInputWrapper = new ForestPlotInputWrapper(this.fixedRows, true, this.getPressEffectSizeType(), this.myNumberFormatter);
                    xxx.add(new TitleSapce(NbBundle.getMessage(CumulativeAnalysis.class, (String)"analysis.cumulative.fixed.name")));
                    xxx.add(new CipWidget(forestPlotInputWrapper, true, this.myNumberFormatter));
                }
                catch (ScaleDataInputErrorException ex) {
                    xxx.add(new TitleSapce(NbBundle.getMessage(CumulativeAnalysis.class, (String)"analysis.cumulative.fixed.name")));
                }
            }
            t = null;
            t = moderator == null ? TablesGenerator.generateOverallsTable(this.fixedRows) : TablesGenerator.generateModeratorCumulativeTable(this.fixedRows, moderator);
            tmp = new JPanel(new BorderLayout());
            tmp.add((Component)t.getTableHeader(), "North");
            tmp.add((Component)t, "Center");
            xxx.add(tmp);
        }
        if (randomModel) {
            if (panelTitle) {
                try {
                    forestPlotInputWrapper = new ForestPlotInputWrapper(this.randomRows, false, this.getPressEffectSizeType(), this.myNumberFormatter);
                    xxx.add(new TitleSapce(NbBundle.getMessage(CumulativeAnalysis.class, (String)"analysis.cumulative.random.name")));
                    xxx.add(new CipWidget(forestPlotInputWrapper, true, this.myNumberFormatter));
                }
                catch (ScaleDataInputErrorException ex) {
                    xxx.add(new TitleSapce(NbBundle.getMessage(CumulativeAnalysis.class, (String)"analysis.cumulative.random.name")));
                }
            }
            t = null;
            t = moderator == null ? TablesGenerator.generateOverallsTable(this.randomRows) : TablesGenerator.generateModeratorCumulativeTable(this.randomRows, moderator);
            tmp = new JPanel(new BorderLayout());
            tmp.add((Component)t.getTableHeader(), "North");
            tmp.add((Component)t, "Center");
            xxx.add(tmp);
        }
        return xxx;
    }

    public JPanel getGuiReport(boolean panelTitle, boolean fixedModel, boolean randomModel, double zeroLine) {
        return this.getGuiReport(panelTitle, fixedModel, randomModel, zeroLine, null);
    }
}

