/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.analysis.impl.ModeratorsTable;
import metaanalysis.core.entitycomparators.ComparisonNameComparator;
import metaanalysis.core.entitycomparators.OutcomeNameComparator;
import metaanalysis.core.entitycomparators.SubgroupNameComparator;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.core.persistence.Project;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.effectsizes.models.GenericEffectSizeResults;
import metaanalysis.effectsizes.models.GenericSampleSizeValue;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import metaanalysis.effectsizes.models.ISampleSizeValue;

public class DataRowsHandler {
    public static List<AnalysisDataBean> extractFilteredDataRows(long topicId, AnalysisFilter filter, IApplicationManager applicationEventWorker, boolean fixNames) throws AnalysisException {
        ArrayList<AnalysisDataBean> rows = new ArrayList<AnalysisDataBean>();
        int usedTimepoints = applicationEventWorker.getIDataFunction().getMaxTimepointOfTopic(topicId) + 1;
        for (Study study : applicationEventWorker.getIDataFunction().getAllStudiesOfTopic(topicId)) {
            if (filter.getExcludedStudies().contains(new Long(study.getId()))) continue;
            for (Subgroupbranch subgroupbranch : applicationEventWorker.getIDataFunction().getAllSubgroupbranchesOfStudy(study.getId())) {
                if (filter.getExcludedSubgroups().contains(new Integer(subgroupbranch.getSubgroupId()))) continue;
                for (Comparisonbranch comparisonbranch : applicationEventWorker.getIDataFunction().getAllComparisonbranchesOfSubgroupbranch(subgroupbranch.getId())) {
                    if (filter.getExcludedComparisons().contains(new Integer(comparisonbranch.getComparisonId()))) continue;
                    for (Timepointbranch timepointbranch : applicationEventWorker.getIDataFunction().getAllTimepointbranchesOfComparisonbranch(comparisonbranch.getId())) {
                        if (filter.getExcludedTimepoints().contains(new Integer(timepointbranch.getTimepointId()))) continue;
                        for (Outcomebranch outcomebranch : applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfTimepointbranch(timepointbranch.getId())) {
                            if (filter.getExcludedOutcomes().contains(new Integer(outcomebranch.getOutcomeId()))) continue;
                            rows.add(new AnalysisDataBean(filter.getEffectSizeType(), study, subgroupbranch, comparisonbranch, timepointbranch, outcomebranch, applicationEventWorker));
                        }
                    }
                }
            }
        }
        ArrayList<AnalysisDataBean> esNulli = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean row : rows) {
            if (row.getCalculationEffectSize() != null) continue;
            esNulli.add(row);
        }
        for (AnalysisDataBean row : esNulli) {
            rows.remove(row);
        }
        if (filter.isCombineOutcomes()) {
            for (AnalysisDataBean row : rows) {
                row.getRowKey().resetOutcome();
            }
            rows = DataRowsHandler.combineWithCorrelation(rows, filter.getConfidenceInterval(), filter.getCorrelationBetweenOutcomes());
        }
        if (filter.isCombineTimepoints()) {
            for (AnalysisDataBean row : rows) {
                row.getRowKey().resetTimepoint();
            }
            rows = DataRowsHandler.combineWithCorrelation(rows, filter.getConfidenceInterval(), filter.getCorrelationBetweenTimepoints());
        }
        if (filter.isCombineComparisons()) {
            for (AnalysisDataBean row : rows) {
                row.getRowKey().resetComparison();
            }
            rows = DataRowsHandler.combineComparisons(rows, filter.getConfidenceInterval());
        }
        if (filter.isCombineSubgroups()) {
            rows = DataRowsHandler.combineSubgroups(rows, filter);
        }
        if (fixNames) {
            DataRowsHandler.fixNames(rows);
        }
        rows = DataRowsHandler.filterByExcludedCategoricalModeratorLevels(rows, filter.getCategoricalModeratorsExcludedValues());
        rows = DataRowsHandler.filterByExcludedRecodedModeratorLevels(rows, filter.getRecodedModeratorsExcludedValues());
        return rows;
    }

    public static ArrayList<AnalysisDataBean> filterByExcludedRecodedModeratorLevels(ArrayList<AnalysisDataBean> sourceRows, Map<Long, List<String>> exludedRecodedLevelsValues) {
        for (Long recodeId : exludedRecodedLevelsValues.keySet()) {
            ArrayList<AnalysisDataBean> daTogliere = new ArrayList<AnalysisDataBean>();
            for (AnalysisDataBean riga : sourceRows) {
                String get = riga.getModeratorsTable().getRecodedModerators().get(recodeId);
                if (get == null && exludedRecodedLevelsValues.get(recodeId).contains("* Not available")) {
                    daTogliere.add(riga);
                    continue;
                }
                if (!exludedRecodedLevelsValues.get(recodeId).contains(get)) continue;
                daTogliere.add(riga);
            }
            for (AnalysisDataBean riga : daTogliere) {
                sourceRows.remove(riga);
            }
        }
        return sourceRows;
    }

    public static ArrayList<AnalysisDataBean> filterByExcludedCategoricalModeratorLevels(ArrayList<AnalysisDataBean> sourceRows, Map<Integer, List<String>> exludedModeratorsValues) {
        for (Integer moderatorId : exludedModeratorsValues.keySet()) {
            ArrayList<AnalysisDataBean> daTogliere = new ArrayList<AnalysisDataBean>();
            for (AnalysisDataBean riga : sourceRows) {
                String get = riga.getModeratorsTable().getCategoricalModerators().get(moderatorId);
                if (get == null && exludedModeratorsValues.get(moderatorId).contains("* Not available")) {
                    daTogliere.add(riga);
                    continue;
                }
                if (!exludedModeratorsValues.get(moderatorId).contains(get)) continue;
                daTogliere.add(riga);
            }
            for (AnalysisDataBean riga : daTogliere) {
                sourceRows.remove(riga);
            }
        }
        return sourceRows;
    }

    public static ArrayList<AnalysisDataBean> combineSubgroups(List<AnalysisDataBean> sourceRows, AnalysisFilter filter) throws AnalysisException {
        for (AnalysisDataBean row : sourceRows) {
            if (!filter.isCombineSubgroups()) continue;
            row.getRowKey().resetSubgroup();
        }
        ArrayList<AnalysisDataBean> sistemati = new ArrayList<AnalysisDataBean>();
        while (sourceRows.size() > 0) {
            ArrayList<AnalysisDataBean> daMediare = new ArrayList<AnalysisDataBean>();
            AnalysisDataBean perno = sourceRows.get(0);
            for (AnalysisDataBean row : sourceRows) {
                if (!row.hasTheSameKey(perno)) continue;
                daMediare.add(row);
            }
            for (AnalysisDataBean row : daMediare) {
                sourceRows.remove(row);
            }
            if (daMediare.size() <= 0) continue;
            FixedAndRandomAnalysis fix = new FixedAndRandomAnalysis("", daMediare, filter.getPressEffectSizeType(), filter.getConfidenceInterval());
            fix.runFixed();
            AnalysisDataBean risultato = fix.getFixedOverall();
            risultato.getRowKey().copyFrom(((AnalysisDataBean)daMediare.get(0)).getRowKey().duplicate());
            risultato.elaborateName();
            sistemati.add(risultato);
        }
        return sistemati;
    }

    public static ArrayList<AnalysisDataBean> combineComparisons(List<AnalysisDataBean> grezze, double confidenceInterval) throws AnalysisException {
        ArrayList<AnalysisDataBean> sistemati = new ArrayList<AnalysisDataBean>();
        while (grezze.size() > 0) {
            ArrayList<AnalysisDataBean> daMediare = new ArrayList<AnalysisDataBean>();
            AnalysisDataBean perno = grezze.get(0);
            for (AnalysisDataBean row : grezze) {
                if (!row.hasTheSameKey(perno)) continue;
                daMediare.add(row);
            }
            for (AnalysisDataBean row : daMediare) {
                grezze.remove(row);
            }
            if (daMediare.size() == 1) {
                sistemati.add((AnalysisDataBean)daMediare.get(0));
                continue;
            }
            int totaleSoggetti = 0;
            int totaleGroupA = 0;
            int totaleGroupB = 0;
            double correlation = 0.0;
            for (AnalysisDataBean row : daMediare) {
                totaleGroupA = (int)((double)totaleGroupA + row.getSampleSize().getEstimateGroupA());
                totaleGroupB = (int)((double)totaleGroupB + row.getSampleSize().getEstimateGroupB());
                correlation = 1.0 * (double)totaleGroupB / (1.0 * (double)(totaleSoggetti += row.getSampleSize().getSampleSize()));
            }
            AnalysisDataBean risultato = ((AnalysisDataBean)daMediare.get(0)).duplicate();
            risultato.setCalculationEffectSize(DataRowsHandler.calculateEffectSizeForCombinedRowsWithCorrelation(daMediare, correlation, confidenceInterval));
            risultato.pressConversion(confidenceInterval);
            GenericSampleSizeValue ss = new GenericSampleSizeValue();
            ArrayList<ISampleSizeValue> sampleSizeDaMediare = new ArrayList<ISampleSizeValue>();
            for (AnalysisDataBean row : daMediare) {
                sampleSizeDaMediare.add(row.getSampleSize());
            }
            ISampleSizeValue meanSampleSize = GenericSampleSizeValue.meanPerComparisonsSampleSize(sampleSizeDaMediare);
            risultato.setSampleSize(meanSampleSize);
            risultato.setModeratorsTable(DataRowsHandler.mergeModeratorsTable(daMediare));
            sistemati.add(risultato);
        }
        return sistemati;
    }

    public static ArrayList<AnalysisDataBean> combineWithCorrelation(List<AnalysisDataBean> grezze, double confidenceInterval, double correlation) throws AnalysisException {
        ArrayList<AnalysisDataBean> sistemati = new ArrayList<AnalysisDataBean>();
        while (grezze.size() > 0) {
            ArrayList<AnalysisDataBean> daMediare = new ArrayList<AnalysisDataBean>();
            AnalysisDataBean perno = grezze.get(0);
            for (AnalysisDataBean row : grezze) {
                if (!row.hasTheSameKey(perno)) continue;
                daMediare.add(row);
            }
            for (AnalysisDataBean row : daMediare) {
                grezze.remove(row);
            }
            if (daMediare.size() == 1) {
                sistemati.add((AnalysisDataBean)daMediare.get(0));
                continue;
            }
            AnalysisDataBean risultato = ((AnalysisDataBean)daMediare.get(0)).duplicate();
            risultato.setCalculationEffectSize(DataRowsHandler.calculateEffectSizeForCombinedRowsWithCorrelation(daMediare, correlation, confidenceInterval));
            risultato.pressConversion(confidenceInterval);
            GenericSampleSizeValue ss = new GenericSampleSizeValue();
            ArrayList<ISampleSizeValue> sampleSizeDaMediare = new ArrayList<ISampleSizeValue>();
            for (AnalysisDataBean row : daMediare) {
                sampleSizeDaMediare.add(row.getSampleSize());
            }
            ISampleSizeValue meanSampleSize = GenericSampleSizeValue.meanSampleSize(sampleSizeDaMediare);
            risultato.setSampleSize(meanSampleSize);
            risultato.setModeratorsTable(DataRowsHandler.mergeModeratorsTable(daMediare));
            sistemati.add(risultato);
        }
        return sistemati;
    }

    public static IEffectSizeResults calculateEffectSizeForCombinedRowsWithCorrelation(List<AnalysisDataBean> rows, double correlation, double confidenceInterval) {
        double sommaES = 0.0;
        double sommaVar = 0.0;
        double sommaVarCorr = 0.0;
        for (AnalysisDataBean row : rows) {
            sommaES += row.getCalculationEffectSize().getEffectSize().doubleValue();
            sommaVar += row.getCalculationEffectSize().getVariance().doubleValue();
        }
        boolean comb = false;
        for (int i = 0; i < rows.size(); ++i) {
            for (int j = 0; j < rows.size(); ++j) {
                if (i == j) continue;
                sommaVarCorr += correlation * Math.sqrt(rows.get(i).getCalculationEffectSize().getVariance()) * Math.sqrt(rows.get(j).getCalculationEffectSize().getVariance());
            }
        }
        GenericEffectSizeResults esr = new GenericEffectSizeResults();
        esr.setEffectSize(Double.valueOf(sommaES / (double)rows.size()));
        esr.setVariance(Double.valueOf((sommaVar + sommaVarCorr) / (double)(rows.size() * rows.size())));
        esr.calcolateAllVariables(confidenceInterval);
        return esr;
    }

    public static double calculateSommaPesiFixed(List<AnalysisDataBean> rows) {
        double tmp = 0.0;
        for (AnalysisDataBean row : rows) {
            tmp += row.getRawFixedWeight();
        }
        return tmp;
    }

    public static double calculateSommaPesiRandom(List<AnalysisDataBean> rows) {
        double tmp = 0.0;
        for (AnalysisDataBean row : rows) {
            tmp += row.getRawRandomWeight();
        }
        return tmp;
    }

    public static double calculateSommaDelQuadratoDeiPesiFixed(List<AnalysisDataBean> rows) {
        double tmp = 0.0;
        for (AnalysisDataBean row : rows) {
            tmp += row.getRawFixedWeight() * row.getRawFixedWeight();
        }
        return tmp;
    }

    public static double calculateSommaDelQuadratoDeiPesiRandom(List<AnalysisDataBean> rows) {
        double tmp = 0.0;
        for (AnalysisDataBean row : rows) {
            tmp += row.getRawRandomWeight() * row.getRawRandomWeight();
        }
        return tmp;
    }

    public static double calculateSommaDeiPesiXESFixed(List<AnalysisDataBean> rows) {
        double tmp = 0.0;
        for (AnalysisDataBean row : rows) {
            tmp += row.getRawFixedWeight() * row.getCalculationEffectSize().getEffectSize();
        }
        return tmp;
    }

    public static double calculateSomma_ES2xPesoFixed(List<AnalysisDataBean> rows) {
        double tmp = 0.0;
        for (AnalysisDataBean row : rows) {
            tmp += row.getRawFixedWeight() * row.getCalculationEffectSize().getEffectSize() * row.getCalculationEffectSize().getEffectSize();
        }
        return tmp;
    }

    public static double calculateSommaPesiXESRandom(List<AnalysisDataBean> rows) {
        double tmp = 0.0;
        for (AnalysisDataBean row : rows) {
            tmp += row.getRawRandomWeight() * row.getCalculationEffectSize().getEffectSize();
        }
        return tmp;
    }

    public static ISampleSizeValue sommaSampleSize(List<AnalysisDataBean> rows) {
        GenericSampleSizeValue tmp = new GenericSampleSizeValue();
        for (AnalysisDataBean row : rows) {
            tmp.sum(row.getSampleSize());
        }
        return tmp;
    }

    public static double sommaZValues(List<AnalysisDataBean> rows) {
        double tmp = 0.0;
        for (AnalysisDataBean row : rows) {
            tmp += row.getCalculationEffectSize().getZValue().doubleValue();
        }
        return tmp;
    }

    public static ModeratorsTable mergeModeratorsTable(List<AnalysisDataBean> rows) throws AnalysisException {
        if (rows.isEmpty()) {
            throw new AnalysisException("Merge of moderators failed: 0 rows");
        }
        ModeratorsTable tmp = rows.get(0).getModeratorsTable().duplicate();
        if (rows.size() > 0) {
            ArrayList<Integer> chiavi = new ArrayList<Integer>();
            chiavi.addAll(tmp.getCategoricalModerators().keySet());
            block0: for (Integer moderatorId : chiavi) {
                for (AnalysisDataBean analysisDataBean : rows) {
                    String get1 = analysisDataBean.getModeratorsTable().getCategoricalModerators().get(moderatorId);
                    if (get1 != null && get1.equals(tmp.getCategoricalModerators().get(moderatorId))) continue;
                    tmp.getCategoricalModerators().remove(moderatorId);
                    continue block0;
                }
            }
            ArrayList<Long> chiavi2 = new ArrayList<Long>();
            chiavi2.addAll(tmp.getRecodedModerators().keySet());
            block2: for (Long l : chiavi2) {
                for (AnalysisDataBean row : rows) {
                    String get1 = row.getModeratorsTable().getRecodedModerators().get(l);
                    if (get1 != null && get1.equals(tmp.getRecodedModerators().get(l))) continue;
                    tmp.getRecodedModerators().remove(l);
                    continue block2;
                }
            }
            for (Integer n : tmp.getNumericalModerators().keySet()) {
                boolean bl = true;
                double num = 0.0;
                double den = 0.0;
                for (AnalysisDataBean row : rows) {
                    if (row.getModeratorsTable().getNumericalModerators() == null || row.getModeratorsTable().getNumericalModerators().get(n) == null) {
                        bl = false;
                        break;
                    }
                    num += row.getModeratorsTable().getNumericalModerators().get(n) * (double)row.getSampleSize().getSampleSize();
                    den += (double)row.getSampleSize().getSampleSize();
                }
                if (!bl) continue;
                tmp.getNumericalModerators().put(n, 1.0 * num / den);
            }
        }
        return tmp;
    }

    public static Map<String, ArrayList<AnalysisDataBean>> extractDataRowsForCategoricalModeratorAnalysis(Project project, IApplicationManager applicationEventWorker, Moderator moderator) throws AnalysisException {
        List<AnalysisDataBean> extractDataRowsForStandardAnalysis = DataRowsHandler.extractFilteredDataRows(project.getTopicId(), AnalysisFilter.readAnalysisFilter((String)project.getFilter()), applicationEventWorker, true);
        AnalysisFilter filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        Map categoricalModeratorsExcludedValues = filter.getCategoricalModeratorsExcludedValues();
        ArrayList<AnalysisDataBean> ok = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean row : extractDataRowsForStandardAnalysis) {
            ModeratorsTable moderatorsTable = row.getModeratorsTable();
            if (row.getModeratorsTable().getCategoricalModerators().get(moderator.getId()) == null) continue;
            ok.add(row);
        }
        List<String> livelli = DataRowsHandler.extractLevelsForCategoricalModeratorAnalysis(ok, moderator, (List)categoricalModeratorsExcludedValues.get(moderator.getId()));
        Collections.sort(livelli);
        HashMap<String, ArrayList<AnalysisDataBean>> ret = new HashMap<String, ArrayList<AnalysisDataBean>>();
        for (String livello : livelli) {
            ArrayList<AnalysisDataBean> righeColLivelloGiusto = new ArrayList<AnalysisDataBean>();
            for (AnalysisDataBean row : ok) {
                if (!row.getModeratorsTable().getCategoricalModerators().get(moderator.getId()).equals(livello)) continue;
                righeColLivelloGiusto.add(row);
            }
            DataRowsHandler.fixNames(righeColLivelloGiusto);
            ret.put(livello, righeColLivelloGiusto);
        }
        return ret;
    }

    public static Map<Subgroup, ArrayList<AnalysisDataBean>> extractDataRowsForSubgroupPreAnalysis(Preanalysis preanalysis, IApplicationManager applicationEventWorker) throws AnalysisException {
        List allSubgroupsOfTopic = applicationEventWorker.getIDataFunction().getAllSubgroupsOfTopic(preanalysis.getTopicId().longValue());
        Collections.sort(allSubgroupsOfTopic, new SubgroupNameComparator());
        HashMap tmpMap = new HashMap();
        tmpMap.put(applicationEventWorker.getIDataFunction().getDefaultSubgroup(), new ArrayList());
        for (Object s : allSubgroupsOfTopic) {
            tmpMap.put((Subgroup)s, new ArrayList());
        }
        List<AnalysisDataBean> rows = DataRowsHandler.extractFilteredDataRows(preanalysis.getTopicId(), AnalysisFilter.readAnalysisFilter((String)preanalysis.getFilter()), applicationEventWorker, false);
        block1: for (AnalysisDataBean row : rows) {
            for (Subgroup s : tmpMap.keySet()) {
                if (row.rowKey.getSubgroupbranch().getSubgroupId().intValue() != s.getId()) continue;
                ((ArrayList)tmpMap.get(s)).add(row);
                continue block1;
            }
        }
        HashMap<Subgroup, ArrayList<AnalysisDataBean>> map = new HashMap<Subgroup, ArrayList<AnalysisDataBean>>();
        for (Subgroup s : tmpMap.keySet()) {
            if (((ArrayList)tmpMap.get(s)).size() <= 0) continue;
            map.put(s, (ArrayList<AnalysisDataBean>)tmpMap.get(s));
        }
        DataRowsHandler.fixNames(rows);
        return map;
    }

    public static Map<Comparison, ArrayList<AnalysisDataBean>> extractDataRowsForComparisonPreAnalysis(Preanalysis preanalysis, IApplicationManager applicationEventWorker) throws AnalysisException {
        List allComparisonsOfTopic = applicationEventWorker.getIDataFunction().getAllComparisonsOfTopic(preanalysis.getTopicId().longValue());
        Collections.sort(allComparisonsOfTopic, new ComparisonNameComparator());
        HashMap tmpMap = new HashMap();
        tmpMap.put(applicationEventWorker.getIDataFunction().getDefaultComparison(), new ArrayList());
        for (Object s : allComparisonsOfTopic) {
            tmpMap.put((Comparison)s, new ArrayList());
        }
        List<AnalysisDataBean> rows = DataRowsHandler.extractFilteredDataRows(preanalysis.getTopicId(), AnalysisFilter.readAnalysisFilter((String)preanalysis.getFilter()), applicationEventWorker, false);
        block1: for (AnalysisDataBean row : rows) {
            for (Comparison s : tmpMap.keySet()) {
                if (row.rowKey.getComparisonbranch().getComparisonId().intValue() != s.getId()) continue;
                ((ArrayList)tmpMap.get(s)).add(row);
                continue block1;
            }
        }
        HashMap<Comparison, ArrayList<AnalysisDataBean>> map = new HashMap<Comparison, ArrayList<AnalysisDataBean>>();
        for (Comparison s : tmpMap.keySet()) {
            if (((ArrayList)tmpMap.get(s)).size() <= 0) continue;
            map.put(s, (ArrayList<AnalysisDataBean>)tmpMap.get(s));
        }
        DataRowsHandler.fixNames(rows);
        return map;
    }

    public static Map<Integer, ArrayList<AnalysisDataBean>> extractDataRowsForTimepointPreAnalysis(Preanalysis preanalysis, IApplicationManager applicationEventWorker) throws AnalysisException {
        int maxTimepointOfTopic = applicationEventWorker.getIDataFunction().getMaxTimepointOfTopic(preanalysis.getTopicId().longValue());
        HashMap tmpMap = new HashMap();
        for (int i = 0; i <= maxTimepointOfTopic; ++i) {
            tmpMap.put(i, new ArrayList());
        }
        List<AnalysisDataBean> rows = DataRowsHandler.extractFilteredDataRows(preanalysis.getTopicId(), AnalysisFilter.readAnalysisFilter((String)preanalysis.getFilter()), applicationEventWorker, false);
        block1: for (AnalysisDataBean row : rows) {
            for (Integer s : tmpMap.keySet()) {
                if (row.rowKey.getTimepointbranch().getTimepointId().intValue() != s.intValue()) continue;
                ((ArrayList)tmpMap.get(s)).add(row);
                continue block1;
            }
        }
        TreeMap<Integer, ArrayList<AnalysisDataBean>> map = new TreeMap<Integer, ArrayList<AnalysisDataBean>>();
        for (Integer s : tmpMap.keySet()) {
            if (((ArrayList)tmpMap.get(s)).size() <= 0) continue;
            map.put(s, (ArrayList<AnalysisDataBean>)tmpMap.get(s));
        }
        DataRowsHandler.fixNames(rows);
        return map;
    }

    public static Map<Outcome, ArrayList<AnalysisDataBean>> extractDataRowsForOutcomePreAnalysis(Preanalysis preanalysis, IApplicationManager applicationEventWorker) throws AnalysisException {
        List allOutcomesOfTopic = applicationEventWorker.getIDataFunction().getAllOutcomesOfTopic(preanalysis.getTopicId().longValue());
        Collections.sort(allOutcomesOfTopic, new OutcomeNameComparator());
        HashMap tmpMap = new HashMap();
        for (Object s : allOutcomesOfTopic) {
            tmpMap.put((Outcome)s, new ArrayList());
        }
        List<AnalysisDataBean> rows = DataRowsHandler.extractFilteredDataRows(preanalysis.getTopicId(), AnalysisFilter.readAnalysisFilter((String)preanalysis.getFilter()), applicationEventWorker, false);
        block1: for (AnalysisDataBean row : rows) {
            for (Outcome s : tmpMap.keySet()) {
                if (row.rowKey.getOutcomebranch().getOutcomeId().intValue() != s.getId()) continue;
                ((ArrayList)tmpMap.get(s)).add(row);
                continue block1;
            }
        }
        HashMap<Outcome, ArrayList<AnalysisDataBean>> map = new HashMap<Outcome, ArrayList<AnalysisDataBean>>();
        for (Outcome s : tmpMap.keySet()) {
            if (((ArrayList)tmpMap.get(s)).size() <= 0) continue;
            map.put(s, (ArrayList<AnalysisDataBean>)tmpMap.get(s));
        }
        DataRowsHandler.fixNames(rows);
        return map;
    }

    public static List<String> extractLevelsForCategoricalModeratorAnalysis(List<AnalysisDataBean> rows, Moderator moderator, List<String> esclusi) {
        ArrayList<String> ok = new ArrayList<String>();
        for (AnalysisDataBean row : rows) {
            if (ok.contains(row.getModeratorsTable().getCategoricalModerators().get(moderator.getId())) || esclusi != null && esclusi.contains(row.getModeratorsTable().getCategoricalModerators().get(moderator.getId()))) continue;
            ok.add(row.getModeratorsTable().getCategoricalModerators().get(moderator.getId()));
        }
        return ok;
    }

    public static Map<String, ArrayList<AnalysisDataBean>> extractDataRowsForRecodedModeratorAnalysis(Project project, IApplicationManager applicationEventWorker, Moderatorrecode moderatorrecode) throws AnalysisException {
        List<AnalysisDataBean> extractDataRowsForStandardAnalysis = DataRowsHandler.extractFilteredDataRows(project.getTopicId(), AnalysisFilter.readAnalysisFilter((String)project.getFilter()), applicationEventWorker, true);
        ArrayList<AnalysisDataBean> ok = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean row : extractDataRowsForStandardAnalysis) {
            if (row.getModeratorsTable().getRecodedModerators().get(moderatorrecode.getId()) == null) continue;
            ok.add(row);
        }
        AnalysisFilter filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        List<String> livelli = DataRowsHandler.extractLevelsForRecodedModeratorAnalysis(ok, moderatorrecode, (List)filter.getRecodedModeratorsExcludedValues().get(moderatorrecode.getId()));
        HashMap<String, ArrayList<AnalysisDataBean>> ret = new HashMap<String, ArrayList<AnalysisDataBean>>();
        for (String livello : livelli) {
            ArrayList<AnalysisDataBean> righeColLivelloGiusto = new ArrayList<AnalysisDataBean>();
            for (AnalysisDataBean row : ok) {
                if (!row.getModeratorsTable().getRecodedModerators().get(moderatorrecode.getId()).equals(livello)) continue;
                righeColLivelloGiusto.add(row);
            }
            DataRowsHandler.fixNames(righeColLivelloGiusto);
            ret.put(livello, righeColLivelloGiusto);
        }
        return ret;
    }

    public static List<String> extractLevelsForRecodedModeratorAnalysis(List<AnalysisDataBean> rows, Moderatorrecode moderatorrecode, List<String> esclusi) {
        ArrayList<String> ok = new ArrayList<String>();
        for (AnalysisDataBean row : rows) {
            if (ok.contains(row.getModeratorsTable().getRecodedModerators().get(moderatorrecode.getId())) || esclusi != null && esclusi.contains(row.getModeratorsTable().getRecodedModerators().get(moderatorrecode.getId()))) continue;
            ok.add(row.getModeratorsTable().getRecodedModerators().get(moderatorrecode.getId()));
        }
        return ok;
    }

    public static void fixNames(List<AnalysisDataBean> rows) {
        Subgroup subgroup;
        Comparison comparison;
        Integer t;
        boolean resetOutcome = true;
        boolean resetTimepoint = true;
        boolean resetComparison = true;
        boolean resetSubgroup = true;
        if (rows.size() <= 1) {
            return;
        }
        Outcome o = rows.get(0).getRowKey().getOutcome();
        if (o != null) {
            for (AnalysisDataBean analysisDataBean : rows) {
                if (analysisDataBean.getRowKey().getOutcome() != null && o.getId() == analysisDataBean.getRowKey().getOutcome().getId()) continue;
                resetOutcome = false;
                break;
            }
        }
        if (resetOutcome) {
            for (AnalysisDataBean analysisDataBean : rows) {
                analysisDataBean.getRowKey().resetOutcome();
            }
        }
        if ((t = rows.get(0).getRowKey().getTimepoint()) != null) {
            for (AnalysisDataBean analysisDataBean : rows) {
                if (analysisDataBean.getRowKey().getTimepoint() != null && t.intValue() == analysisDataBean.getRowKey().getTimepoint().intValue()) continue;
                resetTimepoint = false;
                break;
            }
        }
        if (resetTimepoint) {
            for (AnalysisDataBean analysisDataBean : rows) {
                analysisDataBean.getRowKey().resetTimepoint();
            }
        }
        if ((comparison = rows.get(0).getRowKey().getComparison()) != null) {
            for (AnalysisDataBean row : rows) {
                if (row.getRowKey().getComparison() != null && comparison.getId() == row.getRowKey().getComparison().getId()) continue;
                resetComparison = false;
                break;
            }
        }
        if (resetComparison) {
            for (AnalysisDataBean row : rows) {
                row.getRowKey().resetComparison();
            }
        }
        if ((subgroup = rows.get(0).getRowKey().getSubgroup()) != null) {
            for (AnalysisDataBean row : rows) {
                if (row.getRowKey().getSubgroup() != null && subgroup.getId() == row.getRowKey().getSubgroup().getId()) continue;
                resetSubgroup = false;
                break;
            }
        }
        if (resetSubgroup) {
            for (AnalysisDataBean row : rows) {
                row.getRowKey().resetSubgroup();
            }
        }
        for (AnalysisDataBean row : rows) {
            row.elaborateName();
        }
    }

    public static List<AnalysisDataBean> filterModeratorRowsNotNull(List<AnalysisDataBean> rows, Moderator moderator) {
        ArrayList<AnalysisDataBean> ret = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean row : rows) {
            if (row.getModeratorsTable().checkModeratorNullValue(moderator)) continue;
            ret.add(row);
        }
        return ret;
    }

    public boolean checkModeratorValueNotNull(Moderatorvalue mv) {
        if (mv.getModeratortype() == Moderator.categoricalType) {
            return mv.getCategoricalvalue() != null;
        }
        if (mv.getModeratortype() == Moderator.integerType) {
            return mv.getIntegervalue() != null;
        }
        if (mv.getModeratortype() == Moderator.continuousType) {
            return mv.getContinuousvalue() != null;
        }
        return false;
    }
}

