/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.util.ArrayList;
import java.util.List;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.core.analysis.HeterogeneityStatistic;
import metaanalysis.core.analysis.impl.AAnalysis;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.DataRowsHandler;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Project;
import metaanalysis.effectsizes.models.GenericEffectSizeResults;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public class FixedAndRandomAnalysis
extends AAnalysis {
    private transient NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
    protected HeterogeneityStatistic heterogeneityStatistic;
    protected double variableC;
    protected double variableCRandom;
    protected double sommaPesiFixed;
    protected double sommaDelQuadratoDeiPesiFixed;
    protected double sommaDeiPesiXESFixed;
    protected double somma_ES2xPesoFixed;
    protected double variableQFixed;
    protected double variableQRandom;
    protected AnalysisDataBean fixedOverall;
    protected AnalysisDataBean randomOverall;

    public FixedAndRandomAnalysis(Project project, IApplicationManager applicationEventWorker) throws AnalysisException {
        super("Fixed / Random", project, applicationEventWorker);
    }

    public FixedAndRandomAnalysis(String name, List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval) throws AnalysisException {
        super(name, rows, pressEffectSizeType, confidenceInterval);
    }

    public HeterogeneityStatistic getHeterogeneityStatistic() {
        return this.heterogeneityStatistic;
    }

    public double getVariableC() {
        return this.variableC;
    }

    public double getVariableCRandom() {
        return this.variableCRandom;
    }

    public double getSommaPesi() {
        return this.sommaPesiFixed;
    }

    public double getSommaDelQuadratoDeiPesiFixed() {
        return this.sommaDelQuadratoDeiPesiFixed;
    }

    public double getSommaDeiPesiXESFixed() {
        return this.sommaDeiPesiXESFixed;
    }

    public double getSomma_ES2xPesoFixed() {
        return this.somma_ES2xPesoFixed;
    }

    public double getVariableQ() {
        return this.variableQFixed;
    }

    public double getVariableQRandom() {
        return this.variableQRandom;
    }

    public void runFixed() throws AnalysisException {
        this.setFixedWeights();
        this.sommaPesiFixed = DataRowsHandler.calculateSommaPesiFixed(this.datarows);
        this.sommaDelQuadratoDeiPesiFixed = DataRowsHandler.calculateSommaDelQuadratoDeiPesiFixed(this.datarows);
        this.sommaDeiPesiXESFixed = DataRowsHandler.calculateSommaDeiPesiXESFixed(this.datarows);
        this.somma_ES2xPesoFixed = DataRowsHandler.calculateSomma_ES2xPesoFixed(this.datarows);
        this.variableC = this.sommaPesiFixed - this.sommaDelQuadratoDeiPesiFixed / this.sommaPesiFixed;
        if (this.df > 0) {
            double m = this.sommaDeiPesiXESFixed / this.sommaPesiFixed;
            double vm = 1.0 / this.sommaPesiFixed;
            double sem = Math.sqrt(vm);
            GenericEffectSizeResults fixedResults = new GenericEffectSizeResults();
            fixedResults.setEffectSize(Double.valueOf(m));
            fixedResults.setVariance(Double.valueOf(vm));
            fixedResults.calcolateAllVariables(this.getConfidenceInterval());
            AnalysisDataBean xxx = new AnalysisDataBean();
            xxx.setName("Overall (fixed-effect model)");
            xxx.setCalculationEffectSize((IEffectSizeResults)fixedResults);
            xxx.setPressEffectSizeType(this.pressEffectSizeType);
            xxx.pressConversion(this.getConfidenceInterval());
            xxx.setSampleSize(DataRowsHandler.sommaSampleSize(this.datarows));
            xxx.fillRawFixedWeight();
            this.fixedOverall = xxx;
            this.fixedOverall.setModeratorsTable(DataRowsHandler.mergeModeratorsTable(this.datarows));
        } else {
            this.fixedOverall = ((AnalysisDataBean)this.datarows.get(0)).duplicate();
        }
        this.fixedOverall.setNumberOfStudies(this.df + 1);
        this.heterogeneityStatistic = this.calculateHeterogeneity();
        this.variableQFixed = this.somma_ES2xPesoFixed - Math.pow(this.sommaDeiPesiXESFixed, 2.0) / this.sommaPesiFixed;
    }

    public void calculateFixedResiduals() throws AnalysisException {
        if (this.datarows.size() < 2) {
            if (this.datarows.size() == 1) {
                ((AnalysisDataBean)this.datarows.get(0)).setFixedResiduo(0.0);
                ((AnalysisDataBean)this.datarows.get(0)).setFixedResiduoPValue(1.0);
            }
            return;
        }
        for (AnalysisDataBean tmp : this.datarows) {
            ArrayList<AnalysisDataBean> lista = new ArrayList<AnalysisDataBean>();
            for (AnalysisDataBean row : this.datarows) {
                if (row == tmp) continue;
                lista.add(row.duplicate());
            }
            FixedAndRandomAnalysis xxx = new FixedAndRandomAnalysis("", lista, this.getPressEffectSizeType(), this.getConfidenceInterval());
            xxx.runFixed();
            double grezzo = tmp.getCalculationEffectSize().getEffectSize() - xxx.getFixedOverall().getCalculationEffectSize().getEffectSize();
            double sub = Math.sqrt(tmp.getCalculationEffectSize().getVariance() + xxx.heterogeneityStatistic.getT2() + xxx.getFixedOverall().getCalculationEffectSize().getVariance());
            tmp.setFixedResiduo(grezzo / sub);
            try {
                tmp.setFixedResiduoPValue((1.0 - this.normalDistribution.cumulativeProbability(Math.abs(tmp.getFixedResiduo()))) * 2.0);
            }
            catch (MathException ex) {
                throw new AnalysisException(ex.getMessage());
            }
        }
    }

    public void calculateRandomResiduals() throws AnalysisException {
        if (this.datarows.size() < 2) {
            if (this.datarows.size() == 1) {
                ((AnalysisDataBean)this.datarows.get(0)).setRandomResiduo(0.0);
                ((AnalysisDataBean)this.datarows.get(0)).setRandomResiduoPValue(1.0);
            }
            return;
        }
        for (AnalysisDataBean tmp : this.datarows) {
            ArrayList<AnalysisDataBean> lista = new ArrayList<AnalysisDataBean>();
            for (AnalysisDataBean row : this.datarows) {
                if (row == tmp) continue;
                lista.add(row.duplicate());
            }
            FixedAndRandomAnalysis xxx = new FixedAndRandomAnalysis("", lista, this.getPressEffectSizeType(), this.getConfidenceInterval());
            xxx.runFixed();
            xxx.runRandom();
            double grezzo = tmp.getCalculationEffectSize().getEffectSize() - xxx.getRandomOverall().getCalculationEffectSize().getEffectSize();
            double sub = Math.sqrt(tmp.getCalculationEffectSize().getVariance() + xxx.heterogeneityStatistic.getT2() + xxx.getRandomOverall().getCalculationEffectSize().getVariance());
            tmp.setRandomResiduo(grezzo / sub);
            try {
                tmp.setRandomResiduoPValue((1.0 - this.normalDistribution.cumulativeProbability(Math.abs(tmp.getRandomResiduo()))) * 2.0);
            }
            catch (MathException ex) {
                throw new AnalysisException(ex.getMessage());
            }
        }
    }

    public void runRandom() throws AnalysisException {
        double t2;
        if (this.df == 0) {
            t2 = 0.0;
        } else {
            t2 = (this.variableQFixed - (double)this.df) / this.variableC;
            if (t2 < 0.0) {
                t2 = 0.0;
            }
        }
        this.runRandom(t2);
    }

    public void runRandom(double tSquare) throws AnalysisException {
        this.setRandomWeights(tSquare);
        double sommaPesiRandom = this.calculateRawRandomWeightSum();
        double sommaDelQuadratoDeiPesiRandom = DataRowsHandler.calculateSommaDelQuadratoDeiPesiRandom(this.datarows);
        if (this.df == 0) {
            this.setRandomOverall(this.getFixedOverall());
        } else {
            double mr = DataRowsHandler.calculateSommaPesiXESRandom(this.datarows) / DataRowsHandler.calculateSommaPesiRandom(this.datarows);
            double vmr = 1.0 / DataRowsHandler.calculateSommaPesiRandom(this.datarows);
            GenericEffectSizeResults randomResults = new GenericEffectSizeResults();
            randomResults.setEffectSize(Double.valueOf(mr));
            randomResults.setVariance(Double.valueOf(vmr));
            randomResults.calcolateAllVariables(this.getConfidenceInterval());
            AnalysisDataBean xxx = new AnalysisDataBean();
            xxx.setName("Overall (random-effects model)");
            xxx.setCalculationEffectSize((IEffectSizeResults)randomResults);
            xxx.setPressEffectSizeType(this.pressEffectSizeType);
            xxx.pressConversion(this.getConfidenceInterval());
            xxx.setSampleSize(DataRowsHandler.sommaSampleSize(this.datarows));
            xxx.fillRawFixedWeight();
            this.randomOverall = xxx;
            this.randomOverall.setModeratorsTable(this.getFixedOverall().getModeratorsTable());
        }
        this.variableCRandom = sommaPesiRandom - sommaDelQuadratoDeiPesiRandom / sommaPesiRandom;
        this.variableQRandom = this.calculateQRandom();
        this.randomOverall.setNumberOfStudies(this.df + 1);
    }

    public final void setRandomWeights(double tSquare) {
        this.setRawRandomWeights(tSquare);
        this.setPercentRandomWeights();
    }

    public final void setRawRandomWeights(double tSquare) {
        for (AnalysisDataBean row : this.datarows) {
            row.fillRawRandomWeight(tSquare);
        }
    }

    public final void setPercentRandomWeights() {
        double sum = this.calculateRawRandomWeightSum();
        for (AnalysisDataBean row : this.datarows) {
            row.setRandomWeight(row.getRawRandomWeight() * 100.0 / sum);
        }
    }

    public final void setFixedWeights() {
        for (AnalysisDataBean row : this.datarows) {
            row.fillRawFixedWeight();
        }
        double sum = this.calculateRawFixedWeightSum();
        for (AnalysisDataBean row : this.datarows) {
            row.setFixedWeight(row.getRawFixedWeight() * 100.0 / sum);
        }
    }

    public double calculateRawFixedWeightSum() {
        return DataRowsHandler.calculateSommaPesiFixed(this.datarows);
    }

    public double calculateRawRandomWeightSum() {
        return DataRowsHandler.calculateSommaPesiRandom(this.datarows);
    }

    private double calculateQRandom() {
        double tmp = 0.0;
        for (AnalysisDataBean row : this.datarows) {
            tmp += row.getRawRandomWeight() * Math.pow(row.getCalculationEffectSize().getEffectSize() - this.getRandomOverall().getCalculationEffectSize().getEffectSize(), 2.0);
        }
        return tmp;
    }

    public List<AnalysisDataBean> getOveralls() {
        ArrayList<AnalysisDataBean> tmp = new ArrayList<AnalysisDataBean>();
        tmp.add(this.fixedOverall);
        tmp.add(this.randomOverall);
        return tmp;
    }

    public AnalysisDataBean getFixedOverall() {
        return this.fixedOverall;
    }

    public AnalysisDataBean getRandomOverall() {
        return this.randomOverall;
    }

    public void setRandomOverall(AnalysisDataBean randomOverall) {
        this.randomOverall = randomOverall;
    }

    public final HeterogeneityStatistic calculateHeterogeneity() throws AnalysisException {
        HeterogeneityStatistic hsTmp;
        double i2H;
        if (this.getDf() == 0) {
            return new HeterogeneityStatistic(0.0, 0, 1.0, 0.0, 0.0, 0.0);
        }
        double qH = 0.0;
        for (AnalysisDataBean row : this.getDatarows()) {
            qH += row.getRawFixedWeight() * Math.pow(row.getCalculationEffectSize().getEffectSize() - this.getFixedOverall().getCalculationEffectSize().getEffectSize(), 2.0);
        }
        double t2H = (qH - (double)this.getDf()) / this.getVariableC();
        if (t2H < 0.0) {
            t2H = 0.0;
        }
        if ((i2H = (qH - (double)this.getDf()) / qH * 100.0) < 0.0) {
            i2H = 0.0;
        }
        ChiSquaredDistributionImpl chiSquaredDistribution = new ChiSquaredDistributionImpl((double)this.getDf());
        try {
            hsTmp = new HeterogeneityStatistic(qH, this.getDf(), 1.0 - chiSquaredDistribution.cumulativeProbability(qH), Math.sqrt(t2H), t2H, i2H);
        }
        catch (MathException ex) {
            hsTmp = new HeterogeneityStatistic(0.0, 0, 0.0, 0.0, 0.0, 0.0);
        }
        return hsTmp;
    }
}

