/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

public class LinearRegression {
    double[][] V;
    public double[] C;
    public double[] SEC;
    double RYSQ;
    double SDV;
    double FReg;
    double[] Ycalc;
    double[] DY;

    public double getFisherF() {
        return this.FReg;
    }

    public double getCorrelationCoefficient() {
        return this.RYSQ;
    }

    public double getStandardDeviation() {
        return this.SDV;
    }

    public double[] getCalculatedValues() {
        return this.Ycalc;
    }

    public double[] getResiduals() {
        return this.DY;
    }

    public double[] getCoefficients() {
        return this.C;
    }

    public double[] getCoefficientsStandardError() {
        return this.SEC;
    }

    public double[][] VarianceMatrix() {
        return this.V;
    }

    public boolean regress(double[] Y, double[][] X, double[] W) {
        int k;
        int j;
        int i;
        if (X.length < 0) {
            return false;
        }
        int M = Y.length;
        int N = X.length * X[0].length / M;
        int NDF = M - N;
        this.Ycalc = new double[M];
        this.DY = new double[M];
        if (NDF < 1) {
            return false;
        }
        this.V = new double[N][N];
        this.C = new double[N];
        this.SEC = new double[N];
        double[] B = new double[N];
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                this.V[i][j] = 0.0;
            }
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                this.V[i][j] = 0.0;
                for (int k2 = 0; k2 < M; ++k2) {
                    this.V[i][j] = this.V[i][j] + W[k2] * X[i][k2] * X[j][k2];
                }
            }
            B[i] = 0.0;
            for (int k3 = 0; k3 < M; ++k3) {
                B[i] = B[i] + W[k3] * X[i][k3] * Y[k3];
            }
        }
        if (!this.invertSymmetricMatrix(this.V)) {
            return false;
        }
        for (i = 0; i < N; ++i) {
            this.C[i] = 0.0;
            for (j = 0; j < N; ++j) {
                this.C[i] = this.C[i] + this.V[i][j] * B[j];
            }
        }
        double TSS = 0.0;
        double RSS = 0.0;
        double YBAR = 0.0;
        double WSUM = 0.0;
        for (k = 0; k < M; ++k) {
            YBAR += W[k] * Y[k];
            WSUM += W[k];
        }
        YBAR /= WSUM;
        for (k = 0; k < M; ++k) {
            this.Ycalc[k] = 0.0;
            for (int i2 = 0; i2 < N; ++i2) {
                this.Ycalc[k] = this.Ycalc[k] + this.C[i2] * X[i2][k];
            }
            this.DY[k] = this.Ycalc[k] - Y[k];
            TSS += W[k] * (Y[k] - YBAR) * (Y[k] - YBAR);
            RSS += W[k] * this.DY[k] * this.DY[k];
        }
        double SSQ = RSS / (double)NDF;
        this.RYSQ = 1.0 - RSS / TSS;
        this.FReg = 9999999.0;
        if (this.RYSQ < 0.9999999) {
            this.FReg = this.RYSQ / (1.0 - this.RYSQ) * (double)NDF / (double)(N - 1);
        }
        this.SDV = Math.sqrt(SSQ);
        for (int i3 = 0; i3 < N; ++i3) {
            for (int j2 = 0; j2 < N; ++j2) {
                this.V[i3][j2] = this.V[i3][j2] * SSQ;
            }
            this.SEC[i3] = Math.sqrt(this.V[i3][i3]);
        }
        return true;
    }

    public boolean invertSymmetricMatrix(double[][] V) {
        int L;
        int M;
        if (V.length < 1) {
            return false;
        }
        int N = (int)Math.sqrt(V.length * V[0].length);
        double[] t = new double[N];
        double[] Q = new double[N];
        double[] R = new double[N];
        for (M = 0; M < N; ++M) {
            R[M] = 1.0;
        }
        int K = 0;
        for (M = 0; M < N; ++M) {
            double Big = 0.0;
            for (L = 0; L < N; ++L) {
                double AB = Math.abs(V[L][L]);
                if (!(AB > Big) || R[L] == 0.0) continue;
                Big = AB;
                K = L;
            }
            if (Big == 0.0) {
                return false;
            }
            R[K] = 0.0;
            Q[K] = 1.0 / V[K][K];
            t[K] = 1.0;
            V[K][K] = 0.0;
            if (K != 0) {
                for (L = 0; L < K; ++L) {
                    t[L] = V[L][K];
                    Q[L] = R[L] == 0.0 ? V[L][K] * Q[K] : -V[L][K] * Q[K];
                    V[L][K] = 0.0;
                }
            }
            if (K + 1 < N) {
                for (L = K + 1; L < N; ++L) {
                    t[L] = R[L] != 0.0 ? V[K][L] : -V[K][L];
                    Q[L] = -V[K][L] * Q[K];
                    V[K][L] = 0.0;
                }
            }
            for (L = 0; L < N; ++L) {
                for (K = L; K < N; ++K) {
                    V[L][K] = V[L][K] + t[L] * Q[K];
                }
            }
        }
        M = N;
        L = N - 1;
        for (K = 1; K < N; ++K) {
            --M;
            --L;
            for (int J = 0; J <= L; ++J) {
                V[M][J] = V[J][M];
            }
        }
        return true;
    }
}

