/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import formattazione.numeri.MyNumberFormatter;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.application.style.BigTitleFullSize;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.analysis.impl.LinearRegression;
import metaanalysis.core.analysis.impl.SummaryReport;
import metaanalysis.core.analysis.panels.CumulativeModeratorAnalysisPanel;
import metaanalysis.core.analysis.panels.NumericalRegressionPanel;
import metaanalysis.core.analysis.panels.TitleSapce;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Project;
import metaanalysis.graph.scatterplot.ScatterPlotGraphInput;
import metaanalysis.graph.scatterplot.ScatterPlotRow;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.FDistributionImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ModeratorNumericalReport
implements IAnalysis {
    protected JPanel gui = new JPanel();
    protected boolean fixedModel = true;
    protected boolean randomModel = true;
    private final Moderator moderator;
    private MyNumberFormatter myNumberFormatter;

    public ModeratorNumericalReport(Project project, IApplicationManager applicationEventWorker, Moderator moderator) throws AnalysisException {
        ScatterPlotGraphInput graphInput;
        NumericalRegressionPanel nrp;
        FDistributionImpl dist;
        double cumulativeProbability;
        double[] coef;
        Object lr;
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        AnalysisFilter filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        FixedAndRandomAnalysis fixedAndRandom = new FixedAndRandomAnalysis(project, applicationEventWorker);
        this.moderator = moderator;
        fixedAndRandom.filterByModerator(moderator);
        fixedAndRandom.runFixed();
        fixedAndRandom.runRandom();
        this.gui.setLayout(new BoxLayout(this.gui, 1));
        this.gui.setBackground(StyleProvider.panelBackground);
        this.gui.add((Component)new BigTitleFullSize(NbBundle.getMessage(ModeratorNumericalReport.class, (String)"ModeratorNumericalReport.pagetitle"), ""));
        int predittori = 1;
        List<AnalysisDataBean> rows = fixedAndRandom.getDatarows();
        if (rows.size() < 3) {
            throw new AnalysisException(NbBundle.getMessage(ModeratorNumericalReport.class, (String)"Error.pochiStudi", (Object)rows.size()));
        }
        double[] es = new double[rows.size()];
        double[] dummy = new double[rows.size()];
        double[] modVal = new double[rows.size()];
        double[] wfix = new double[rows.size()];
        double[] wran = new double[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            es[i] = rows.get(i).getCalculationEffectSize().getEffectSize();
            dummy[i] = 1.0;
            modVal[i] = rows.get(i).getModeratorsTable().getNumericalModerators().get(moderator.getId());
            wfix[i] = rows.get(i).getRawFixedWeight();
            wran[i] = rows.get(i).getRawRandomWeight();
        }
        if (filter.isFixedMode()) {
            ArrayList<ScatterPlotRow> righe = new ArrayList<ScatterPlotRow>();
            for (AnalysisDataBean row : rows) {
                righe.add(new ScatterPlotRow(row.getName(), row.getCalculationEffectSize().getEffectSize(), row.getModeratorsTable().getNumericalModerators().get(moderator.getId()), Double.valueOf(row.getFixedWeight())));
            }
            lr = new LinearRegression();
            ((LinearRegression)lr).regress(es, new double[][]{dummy, modVal}, wfix);
            coef = ((LinearRegression)lr).getCoefficients();
            cumulativeProbability = 0.0;
            dist = new FDistributionImpl((double)predittori, (double)(rows.size() - 1 - predittori));
            try {
                cumulativeProbability = 1.0 - dist.cumulativeProbability(((LinearRegression)lr).getFisherF());
            }
            catch (MathException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            nrp = new NumericalRegressionPanel(coef[1], coef[0], cumulativeProbability, rows.size(), this.myNumberFormatter);
            graphInput = new ScatterPlotGraphInput("Scatter Plot", moderator.getName(), righe, coef[1], coef[0]);
            this.gui.add(new TitleSapce(NbBundle.getMessage(ModeratorNumericalReport.class, (String)"RegressionAnalisys.fixed.name"), graphInput));
            this.gui.add(nrp);
        }
        if (filter.isRandomMode()) {
            ArrayList<ScatterPlotRow> righe = new ArrayList<ScatterPlotRow>();
            for (AnalysisDataBean row : rows) {
                righe.add(new ScatterPlotRow(row.getName(), row.getCalculationEffectSize().getEffectSize(), row.getModeratorsTable().getNumericalModerators().get(moderator.getId()), Double.valueOf(row.getRandomWeight())));
            }
            lr = new LinearRegression();
            ((LinearRegression)lr).regress(es, new double[][]{dummy, modVal}, wran);
            coef = ((LinearRegression)lr).getCoefficients();
            cumulativeProbability = 0.0;
            dist = new FDistributionImpl((double)predittori, (double)(rows.size() - 1 - predittori));
            try {
                cumulativeProbability = 1.0 - dist.cumulativeProbability(((LinearRegression)lr).getFisherF());
            }
            catch (MathException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            nrp = new NumericalRegressionPanel(coef[1], coef[0], cumulativeProbability, rows.size(), applicationEventWorker.getMyNumberFormatter());
            graphInput = new ScatterPlotGraphInput("Scatter Plot", moderator.getName(), righe, coef[1], coef[0]);
            this.gui.add(new TitleSapce(NbBundle.getMessage(ModeratorNumericalReport.class, (String)"RegressionAnalisys.random.name"), graphInput));
            this.gui.add(nrp);
        }
        this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"CumulativeAnalysis.name")));
        this.gui.add(new CumulativeModeratorAnalysisPanel(moderator, rows, filter, this.myNumberFormatter));
    }

    public JPanel getGuiReport(boolean panelTitle) {
        return this.gui;
    }

    public String getName() {
        return this.moderator.getName();
    }
}

