/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import cip.integrator.CipWidget;
import cip.integrator.ForestPlotInputWrapper;
import forestplot.api.ScaleDataInputErrorException;
import formattazione.numeri.MyNumberFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.application.style.BigTitleFullSize;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.HeterogeneityStatistic;
import metaanalysis.core.analysis.SubgroupHeterogeneityStatistic;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysisList;
import metaanalysis.core.analysis.impl.SummaryReport;
import metaanalysis.core.analysis.impl.qTest2AnovaFixedEffect;
import metaanalysis.core.analysis.impl.qTest2AnovaRandomPooled;
import metaanalysis.core.analysis.impl.qTest2AnovaRandomSeparate;
import metaanalysis.core.analysis.panels.TablesGenerator;
import metaanalysis.core.analysis.panels.TitleSapce;
import org.openide.util.NbBundle;

public abstract class ModeratorORModeratorRecodeReport
implements IAnalysis {
    protected JPanel gui;
    protected boolean fixedModel = true;
    protected boolean randomModel = true;
    private MyNumberFormatter myNumberFormatter;
    private AnalysisFilter filter;

    public ModeratorORModeratorRecodeReport(Map<String, ArrayList<AnalysisDataBean>> mappa, AnalysisFilter filter, boolean isSeparateTSquare, MyNumberFormatter myNumberFormatter) throws AnalysisException {
        this(mappa, filter.getPressEffectSizeType(), filter.getConfidenceInterval(), isSeparateTSquare, filter, myNumberFormatter);
    }

    public ModeratorORModeratorRecodeReport(Map<String, ArrayList<AnalysisDataBean>> mappa, String pressEffectSizeType, double confidenceInterval, boolean isSeparateTSquare, AnalysisFilter filter, MyNumberFormatter myNumberFormatter) throws AnalysisException {
        ForestPlotInputWrapper fpiw;
        this.filter = filter;
        this.myNumberFormatter = myNumberFormatter;
        if (mappa.keySet().size() < 2) {
            throw new AnalysisException(NbBundle.getMessage(ModeratorORModeratorRecodeReport.class, (String)"Error.pochiLivelliModeratore"));
        }
        this.gui = new JPanel();
        this.gui.setLayout(new BoxLayout(this.gui, 1));
        this.gui.setBackground(StyleProvider.panelBackground);
        this.gui.add((Component)new BigTitleFullSize(NbBundle.getMessage(ModeratorORModeratorRecodeReport.class, (String)"ModeratorORModeratorRecodeReport.pagetitle"), ""));
        ArrayList<AnalysisDataBean> overallsFixed = new ArrayList<AnalysisDataBean>();
        ArrayList<AnalysisDataBean> overallsRandom = new ArrayList<AnalysisDataBean>();
        ArrayList<HeterogeneityStatistic> hs = new ArrayList<HeterogeneityStatistic>();
        FixedAndRandomAnalysisList analysis = new FixedAndRandomAnalysisList();
        ArrayList<String> livelli_TMP = new ArrayList<String>();
        livelli_TMP.addAll(mappa.keySet());
        Collections.sort(livelli_TMP);
        for (String livello : livelli_TMP) {
            List righe = mappa.get(livello);
            FixedAndRandomAnalysis fixedAndRandomAnalysis = new FixedAndRandomAnalysis(livello, righe, pressEffectSizeType, confidenceInterval);
            fixedAndRandomAnalysis.runFixed();
            fixedAndRandomAnalysis.calculateFixedResiduals();
            fixedAndRandomAnalysis.runRandom();
            fixedAndRandomAnalysis.calculateRandomResiduals();
            analysis.add(fixedAndRandomAnalysis);
            if (filter.isFixedMode()) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(ModeratorORModeratorRecodeReport.class, (String)"FixedAnalysis.name") + " <" + livello + ">"));
                JTable defaultDataEntryFixedTable = TablesGenerator.generateDataTable(fixedAndRandomAnalysis.getDatarows(), false);
                JPanel tmp = new JPanel(new BorderLayout());
                tmp.add((Component)defaultDataEntryFixedTable.getTableHeader(), "North");
                tmp.add((Component)defaultDataEntryFixedTable, "Center");
                this.gui.add(tmp);
            }
            if (filter.isRandomMode()) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(ModeratorORModeratorRecodeReport.class, (String)"RandomAnalysis.name") + " <" + livello + ">"));
                JTable defaultDataEntryRandomTable = TablesGenerator.generateDataTable(fixedAndRandomAnalysis.getDatarows(), true);
                JPanel tmp2 = new JPanel(new BorderLayout());
                tmp2.add((Component)defaultDataEntryRandomTable.getTableHeader(), "North");
                tmp2.add((Component)defaultDataEntryRandomTable, "Center");
                this.gui.add(tmp2);
            }
            if (fixedAndRandomAnalysis.getDf() < 1) continue;
            hs.add(new HeterogeneityStatistic(livello, fixedAndRandomAnalysis));
        }
        ArrayList<SubgroupHeterogeneityStatistic> modi = new ArrayList<SubgroupHeterogeneityStatistic>();
        if (analysis.size() > 1) {
            ArrayList tmpRows = new ArrayList();
            for (FixedAndRandomAnalysis fra : analysis) {
                for (AnalysisDataBean xxx : fra.getDatarows()) {
                    tmpRows.add(xxx.duplicate());
                }
            }
            FixedAndRandomAnalysis global = new FixedAndRandomAnalysis("Global", tmpRows, pressEffectSizeType, confidenceInterval);
            global.runFixed();
            global.runRandom();
            ArrayList heterogeneityStatitics = new ArrayList();
            if (filter.isFixedMode()) {
                modi.add(new qTest2AnovaFixedEffect("ANOVA Q-Test fixed-effect", analysis, global));
            }
            if (filter.isRandomMode()) {
                if (isSeparateTSquare) {
                    modi.add(new qTest2AnovaRandomSeparate("ANOVA Q-Test Random-effects with separate estimates of T2", analysis, pressEffectSizeType, confidenceInterval));
                } else {
                    modi.add(new qTest2AnovaRandomPooled("ANOVA Q-Test Random-effects with pooled estimates of T2", analysis, pressEffectSizeType, confidenceInterval));
                }
            }
        }
        for (FixedAndRandomAnalysis xxx : analysis) {
            xxx.getFixedOverall().setName(xxx.getName());
            xxx.getRandomOverall().setName(xxx.getName());
            overallsFixed.add(xxx.getFixedOverall());
            overallsRandom.add(xxx.getRandomOverall());
        }
        if (filter.isFixedMode()) {
            try {
                fpiw = new ForestPlotInputWrapper(analysis, true, filter.getEffectSizeType(), this.myNumberFormatter);
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"ModeratorOverallsFixedAnalysis.name")));
                this.gui.add(new CipWidget(fpiw, true, this.myNumberFormatter));
            }
            catch (ScaleDataInputErrorException ex) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"ModeratorOverallsFixedAnalysis.name")));
            }
            JTable overallsTable = TablesGenerator.generateOverallsTable(overallsFixed);
            JPanel tmp3 = new JPanel(new BorderLayout());
            tmp3.add((Component)overallsTable.getTableHeader(), "North");
            tmp3.add((Component)overallsTable, "Center");
            this.gui.add(tmp3);
        }
        if (filter.isRandomMode()) {
            try {
                fpiw = new ForestPlotInputWrapper(analysis, false, filter.getEffectSizeType(), this.myNumberFormatter);
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"ModeratorOverallsRandomAnalysis.name")));
                this.gui.add(new CipWidget(fpiw, true, this.myNumberFormatter));
            }
            catch (ScaleDataInputErrorException ex) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"ModeratorOverallsRandomAnalysis.name")));
            }
            JTable overallsTable2 = TablesGenerator.generateOverallsTable(overallsRandom);
            JPanel tmp1 = new JPanel(new BorderLayout());
            tmp1.add((Component)overallsTable2.getTableHeader(), "North");
            tmp1.add((Component)overallsTable2, "Center");
            this.gui.add(tmp1);
        }
        this.gui.add(new TitleSapce(NbBundle.getMessage(ModeratorORModeratorRecodeReport.class, (String)"HeterogeneitySatistic.name")));
        JTable heterogeneity = TablesGenerator.getDefaultHeterogeneityStatisticsTable(hs);
        JPanel tmp4 = new JPanel(new BorderLayout());
        tmp4.add((Component)heterogeneity.getTableHeader(), "North");
        tmp4.add((Component)heterogeneity, "Center");
        this.gui.add(tmp4);
        if (mappa.keySet().size() > 1) {
            this.gui.add(new TitleSapce("Test of difference"));
            JTable defaultDataEntryFixedTable = TablesGenerator.getDefaultSubgroupHeterogeneityStatisticsTable(modi);
            JPanel tmp = new JPanel(new BorderLayout());
            tmp.add((Component)defaultDataEntryFixedTable.getTableHeader(), "North");
            tmp.add((Component)defaultDataEntryFixedTable, "Center");
            this.gui.add(tmp);
        }
    }

    public JPanel getGuiReport(boolean panelTitle) {
        return this.gui;
    }
}

