/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import metaanalysis.application.tools.SpeedyCopy;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.moderatorrecode.apis.ModeratorRecodeMachine;

public class ModeratorsTable
implements SpeedyCopy<ModeratorsTable> {
    protected Map<Integer, String> categoricalModerators = new HashMap<Integer, String>();
    protected Map<Integer, Double> numericalModerators = new HashMap<Integer, Double>();
    protected Map<Long, String> recodedModerators = new HashMap<Long, String>();

    public ModeratorsTable() {
    }

    public ModeratorsTable(Outcomebranch outcomebranch, IApplicationManager applicationEventWorker) {
        long outcomebranchId = outcomebranch.getId();
        long timepointbranchId = outcomebranch.getTimepointbranchId();
        long comparisonbranchId = applicationEventWorker.getIDataFunction().getTimepointbranch(timepointbranchId).getComparisonbranchId();
        long subgroupbranchId = applicationEventWorker.getIDataFunction().getComparisonbranch(comparisonbranchId).getSubgroupbranchId();
        long studyId = applicationEventWorker.getIDataFunction().getSubgroupbranch(subgroupbranchId).getStudyId();
        this.loadModeratorValues(outcomebranchId, applicationEventWorker);
        this.loadModeratorValues(timepointbranchId, applicationEventWorker);
        this.loadModeratorValues(comparisonbranchId, applicationEventWorker);
        this.loadModeratorValues(subgroupbranchId, applicationEventWorker);
        this.loadModeratorValues(studyId, applicationEventWorker);
    }

    private void loadModeratorValues(long nodeId, IApplicationManager applicationEventWorker) {
        List tmp = applicationEventWorker.getIDataFunction().getAllModeratorValuesOfNode(nodeId);
        for (Moderatorvalue mv : tmp) {
            Moderator m = applicationEventWorker.getIDataFunction().getModerator(mv.getId().getModeratorId());
            if (m.getModeratortype() == Moderator.categoricalType) {
                this.categoricalModerators.put(mv.getId().getModeratorId(), mv.getCategoricalvalue());
            } else if (m.getModeratortype() == Moderator.continuousType) {
                this.numericalModerators.put(mv.getId().getModeratorId(), mv.getNumericalValue());
            } else if (m.getModeratortype() == Moderator.integerType) {
                this.numericalModerators.put(mv.getId().getModeratorId(), mv.getNumericalValue());
            }
            for (Moderatorrecode mr : applicationEventWorker.getIDataFunction().getAllModeratorrecodeOfModerator(m)) {
                ModeratorRecodeMachine mrm = ModeratorRecodeMachine.toModeratorRecodingMachine((String)mr.getModeratorrecodingmachine());
                this.recodedModerators.put(mr.getId(), mrm.recode(mv));
            }
        }
    }

    public Map<Integer, Double> getNumericalModerators() {
        return this.numericalModerators;
    }

    public void setNumericalModerators(Map<Integer, Double> numericalModerators) {
        this.numericalModerators = numericalModerators;
    }

    public Map<Integer, String> getCategoricalModerators() {
        return this.categoricalModerators;
    }

    public void setCategoricalModerators(Map<Integer, String> categoricelModerators) {
        this.categoricalModerators = categoricelModerators;
    }

    public Map<Long, String> getRecodedModerators() {
        return this.recodedModerators;
    }

    public void setRecodedModeratorValues(Map<Long, String> recodedModerators) {
        this.recodedModerators = recodedModerators;
    }

    public boolean checkModeratorNullValue(Moderator moderator) {
        return !(moderator.getModeratortype() == Moderator.categoricalType ? this.getCategoricalModerators().get(moderator.getId()) != null : this.getNumericalModerators().get(moderator.getId()) != null);
    }

    public ModeratorsTable duplicate() {
        ModeratorsTable tmp = new ModeratorsTable();
        for (Integer n : this.categoricalModerators.keySet()) {
            tmp.categoricalModerators.put(n, this.categoricalModerators.get(n));
        }
        for (Integer n : this.numericalModerators.keySet()) {
            tmp.numericalModerators.put(n, this.numericalModerators.get(n));
        }
        for (Long l : this.recodedModerators.keySet()) {
            tmp.recodedModerators.put(l, this.recodedModerators.get(l));
        }
        return tmp;
    }

    public void copyFrom(ModeratorsTable obj) {
        this.recodedModerators.clear();
        this.categoricalModerators.clear();
        for (Integer n : obj.categoricalModerators.keySet()) {
            this.categoricalModerators.put(n, obj.categoricalModerators.get(n));
        }
        for (Integer n : obj.numericalModerators.keySet()) {
            this.numericalModerators.put(n, obj.getNumericalModerators().get(n));
        }
        for (Long l : obj.recodedModerators.keySet()) {
            this.recodedModerators.put(l, obj.recodedModerators.get(l));
        }
    }
}

