/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.util.ArrayList;
import java.util.List;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.core.analysis.impl.AAnalysis;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Project;
import org.openide.util.NbBundle;

public class OneStudyRemoveAnalysis
extends AAnalysis {
    protected List<AnalysisDataBean> fixedRows = new ArrayList<AnalysisDataBean>();
    protected List<AnalysisDataBean> randomRows = new ArrayList<AnalysisDataBean>();

    public OneStudyRemoveAnalysis(Project project, IApplicationManager applicationEventWorker) throws AnalysisException {
        super(NbBundle.getMessage(AAnalysis.class, (String)"OneStudyRemoveAnalysis.name"), project, applicationEventWorker);
        this.run();
    }

    public OneStudyRemoveAnalysis(String name, List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval) throws AnalysisException {
        super(name, rows, pressEffectSizeType, confidenceInterval);
        this.run();
    }

    private void run() throws AnalysisException {
        for (AnalysisDataBean perno : this.getDatarows()) {
            ArrayList<AnalysisDataBean> righe = new ArrayList<AnalysisDataBean>();
            for (AnalysisDataBean row : this.getDatarows()) {
                if (perno.equals(row)) continue;
                righe.add(row.duplicate());
            }
            FixedAndRandomAnalysis fra = new FixedAndRandomAnalysis("", righe, this.pressEffectSizeType, this.getConfidenceInterval());
            fra.runFixed();
            fra.runRandom();
            fra.getFixedOverall().setName(perno.getName());
            fra.getRandomOverall().setName(perno.getName());
            this.fixedRows.add(fra.getFixedOverall().duplicate());
            this.randomRows.add(fra.getRandomOverall().duplicate());
        }
    }

    public List<AnalysisDataBean> getFixedRows() {
        return this.fixedRows;
    }

    public void setFixedRows(List<AnalysisDataBean> fixedRows) {
        this.fixedRows = fixedRows;
    }

    public List<AnalysisDataBean> getRandomRows() {
        return this.randomRows;
    }

    public void setRandomRows(List<AnalysisDataBean> randomRows) {
        this.randomRows = randomRows;
    }
}

