/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import cip.integrator.CipWidget;
import cip.integrator.ForestPlotInputWrapper;
import forestplot.api.ScaleDataInputErrorException;
import formattazione.numeri.MyNumberFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.HeterogeneityStatistic;
import metaanalysis.core.analysis.SubgroupHeterogeneityStatistic;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.DataRowsHandler;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysisList;
import metaanalysis.core.analysis.impl.SummaryReport;
import metaanalysis.core.analysis.impl.qTest2AnovaFixedEffect;
import metaanalysis.core.analysis.impl.qTest2AnovaRandomSeparate;
import metaanalysis.core.analysis.panels.TablesGenerator;
import metaanalysis.core.analysis.panels.TitleSapce;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.core.persistence.Subgroup;
import org.openide.util.NbBundle;

public class PreAnalysisReport
implements IAnalysis {
    JPanel gui = new JPanel();
    protected boolean fixedModel = true;
    protected boolean randomModel = true;
    protected final Preanalysis preanalysis;
    protected AnalysisFilter filter;
    public static int subgroupsPreAnalysis = 0;
    public static int comparisonsPreAnalysis = 1;
    public static int timepointsPreAnalysis = 2;
    public static int outcomesPreAnalysis = 3;
    public static String[] labels = new String[]{"subgroupsPreAnalysis", "comparisonsPreAnalysis", "timepointsPreAnalysis", "outcomesPreAnalysis"};
    private final int analysisType;
    private MyNumberFormatter myNumberFormatter;

    public PreAnalysisReport(Preanalysis preanalysis, int analysisType, IApplicationManager applicationEventWorker) throws AnalysisException {
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        this.preanalysis = preanalysis;
        this.analysisType = analysisType;
        this.filter = AnalysisFilter.readAnalysisFilter((String)preanalysis.getFilter());
        this.gui.setLayout(new BoxLayout(this.gui, 1));
        this.gui.setBackground(StyleProvider.panelBackground);
        HashMap<String, ArrayList<AnalysisDataBean>> mappaValida = new HashMap<String, ArrayList<AnalysisDataBean>>();
        if (analysisType == subgroupsPreAnalysis) {
            Map<Subgroup, ArrayList<AnalysisDataBean>> mappa = DataRowsHandler.extractDataRowsForSubgroupPreAnalysis(preanalysis, applicationEventWorker);
            for (Subgroup s : mappa.keySet()) {
                mappaValida.put(s.getName(), mappa.get(s));
            }
        } else if (analysisType == comparisonsPreAnalysis) {
            Map<Comparison, ArrayList<AnalysisDataBean>> mappa = DataRowsHandler.extractDataRowsForComparisonPreAnalysis(preanalysis, applicationEventWorker);
            for (Comparison s : mappa.keySet()) {
                mappaValida.put(s.getName(), mappa.get(s));
            }
        } else if (analysisType == timepointsPreAnalysis) {
            Map<Integer, ArrayList<AnalysisDataBean>> mappa = DataRowsHandler.extractDataRowsForTimepointPreAnalysis(preanalysis, applicationEventWorker);
            for (Integer s : mappa.keySet()) {
                mappaValida.put("W" + (s + 1), mappa.get(s));
            }
        } else if (analysisType == outcomesPreAnalysis) {
            Map<Outcome, ArrayList<AnalysisDataBean>> mappa = DataRowsHandler.extractDataRowsForOutcomePreAnalysis(preanalysis, applicationEventWorker);
            for (Outcome s : mappa.keySet()) {
                mappaValida.put(s.getName(), mappa.get(s));
            }
        }
        this.generatePanel(mappaValida);
    }

    public JPanel getGuiReport(boolean panelTitle) {
        return this.gui;
    }

    public String getName() {
        return NbBundle.getMessage(PreAnalysisReport.class, (String)("PreAnalysisReport." + labels[this.analysisType] + ".name"));
    }

    private void generatePanel(Map<String, ArrayList<AnalysisDataBean>> mappa) throws AnalysisException {
        ForestPlotInputWrapper fpiw;
        if (mappa.keySet().size() < 2) {
            throw new AnalysisException(this.getName() + " - " + NbBundle.getMessage(PreAnalysisReport.class, (String)"Error.pochiLivelli", (Object)mappa.keySet().size()));
        }
        ArrayList<AnalysisDataBean> overallsFixed = new ArrayList<AnalysisDataBean>();
        ArrayList<AnalysisDataBean> overallsRandom = new ArrayList<AnalysisDataBean>();
        ArrayList<HeterogeneityStatistic> hs = new ArrayList<HeterogeneityStatistic>();
        FixedAndRandomAnalysisList analysis = new FixedAndRandomAnalysisList();
        Set<String> keySet = mappa.keySet();
        ArrayList<String> riordina = new ArrayList<String>();
        for (String s : mappa.keySet()) {
            riordina.add(s);
        }
        Collections.sort(riordina);
        for (String livello : riordina) {
            List righe = mappa.get(livello);
            FixedAndRandomAnalysis fixedAndRandomAnalysis = new FixedAndRandomAnalysis(livello, righe, this.filter.getPressEffectSizeType(), this.filter.getConfidenceInterval());
            fixedAndRandomAnalysis.runFixed();
            fixedAndRandomAnalysis.calculateFixedResiduals();
            fixedAndRandomAnalysis.runRandom();
            fixedAndRandomAnalysis.calculateRandomResiduals();
            analysis.add(fixedAndRandomAnalysis);
            if (this.filter.isFixedMode()) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(PreAnalysisReport.class, (String)"FixedAnalysis.name") + " <" + livello + ">"));
                JTable defaultDataEntryFixedTable = TablesGenerator.generateDataTable(fixedAndRandomAnalysis.getDatarows(), false);
                JPanel tmp = new JPanel(new BorderLayout());
                tmp.add((Component)defaultDataEntryFixedTable.getTableHeader(), "North");
                tmp.add((Component)defaultDataEntryFixedTable, "Center");
                this.gui.add(tmp);
            }
            if (this.filter.isRandomMode()) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(PreAnalysisReport.class, (String)"RandomAnalysis.name") + " <" + livello + ">"));
                JTable defaultDataEntryRandomTable = TablesGenerator.generateDataTable(fixedAndRandomAnalysis.getDatarows(), true);
                JPanel tmp2 = new JPanel(new BorderLayout());
                tmp2.add((Component)defaultDataEntryRandomTable.getTableHeader(), "North");
                tmp2.add((Component)defaultDataEntryRandomTable, "Center");
                this.gui.add(tmp2);
            }
            if (fixedAndRandomAnalysis.getDf() < 1) continue;
            hs.add(new HeterogeneityStatistic(livello, fixedAndRandomAnalysis));
        }
        ArrayList<SubgroupHeterogeneityStatistic> modi = new ArrayList<SubgroupHeterogeneityStatistic>();
        if (analysis.size() > 1) {
            ArrayList tmpRows = new ArrayList();
            for (FixedAndRandomAnalysis fra : analysis) {
                for (AnalysisDataBean xxx : fra.getDatarows()) {
                    tmpRows.add(xxx.duplicate());
                }
            }
            FixedAndRandomAnalysis global = new FixedAndRandomAnalysis("Global", tmpRows, this.filter.getPressEffectSizeType(), this.filter.getConfidenceInterval());
            global.runFixed();
            ArrayList heterogeneityStatitics = new ArrayList();
            if (this.filter.isFixedMode()) {
                modi.add(new qTest2AnovaFixedEffect("ANOVA Q-Test fixed-effect", analysis, global));
            }
            if (this.filter.isRandomMode()) {
                modi.add(new qTest2AnovaRandomSeparate("ANOVA Q-Test Random-effects with separate estimates of T2", analysis, this.filter.getPressEffectSizeType(), this.filter.getConfidenceInterval()));
            }
        }
        for (FixedAndRandomAnalysis xxx : analysis) {
            xxx.getFixedOverall().setName(xxx.getName());
            xxx.getRandomOverall().setName(xxx.getName());
            overallsFixed.add(xxx.getFixedOverall());
            overallsRandom.add(xxx.getRandomOverall());
        }
        if (this.filter.isFixedMode()) {
            try {
                fpiw = new ForestPlotInputWrapper(analysis, true, this.filter.getEffectSizeType(), this.myNumberFormatter);
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"PreAnalysisOverallsFixedAnalysis.name")));
                this.gui.add(new CipWidget(fpiw, true, this.myNumberFormatter));
            }
            catch (ScaleDataInputErrorException ex) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"PreAnalysisOverallsFixedAnalysis.name")));
            }
            JTable overallsTable = TablesGenerator.generateOverallsTable(overallsFixed);
            JPanel tmp3 = new JPanel(new BorderLayout());
            tmp3.add((Component)overallsTable.getTableHeader(), "North");
            tmp3.add((Component)overallsTable, "Center");
            this.gui.add(tmp3);
        }
        if (this.filter.isRandomMode()) {
            try {
                fpiw = new ForestPlotInputWrapper(analysis, false, this.filter.getEffectSizeType(), this.myNumberFormatter);
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"PreAnalysisOverallsRandomAnalysis.name")));
                this.gui.add(new CipWidget(fpiw, true, this.myNumberFormatter));
            }
            catch (ScaleDataInputErrorException ex) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"PreAnalysisOverallsRandomAnalysis.name")));
            }
            JTable overallsTable2 = TablesGenerator.generateOverallsTable(overallsRandom);
            JPanel tmp1 = new JPanel(new BorderLayout());
            tmp1.add((Component)overallsTable2.getTableHeader(), "North");
            tmp1.add((Component)overallsTable2, "Center");
            this.gui.add(tmp1);
        }
        this.gui.add(new TitleSapce(NbBundle.getMessage(PreAnalysisReport.class, (String)"HeterogeneitySatistic.name")));
        JTable heterogeneity = TablesGenerator.getDefaultHeterogeneityStatisticsTable(hs);
        JPanel tmp4 = new JPanel(new BorderLayout());
        tmp4.add((Component)heterogeneity.getTableHeader(), "North");
        tmp4.add((Component)heterogeneity, "Center");
        this.gui.add(tmp4);
        if (mappa.keySet().size() > 1) {
            this.gui.add(new TitleSapce("Test of difference"));
            JTable defaultDataEntryFixedTable = TablesGenerator.getDefaultSubgroupHeterogeneityStatisticsTable(modi);
            JPanel tmp = new JPanel(new BorderLayout());
            tmp.add((Component)defaultDataEntryFixedTable.getTableHeader(), "North");
            tmp.add((Component)defaultDataEntryFixedTable, "Center");
            this.gui.add(tmp);
        }
    }
}

