/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.analysis.models.events.PreAnalysisDoneEvent;
import metaanalysis.core.analysis.impl.AAnalysisRunner;
import metaanalysis.core.analysis.impl.PreAnalysisReport;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class PreAnalysisRunner
extends AAnalysisRunner
implements Runnable {
    private Preanalysis preanalysis;

    public PreAnalysisRunner(IApplicationManager iApplicationManager, Preanalysis preanalysis) {
        super(iApplicationManager);
        this.preanalysis = preanalysis;
    }

    public PreAnalysisRunner(IApplicationManager iApplicationManager, long topicId) {
        this(iApplicationManager, (Preanalysis)iApplicationManager.getIDataFunction().getAllPreanalysisOfTopic(topicId).get(0));
    }

    @Override
    public void run() {
        ArrayList<PreAnalysisReport> analisiDaFare = new ArrayList<PreAnalysisReport>();
        this.updateBar(0);
        AnalysisFilter filter = AnalysisFilter.readAnalysisFilter((String)this.preanalysis.getFilter());
        this.progressBarPanel.report.append(" -- Pre-analysis  --\n");
        if (!filter.isCombineSubgroups()) {
            try {
                this.progressBarPanel.report.append("\n " + NbBundle.getMessage(PreAnalysisReport.class, (String)("PreAnalysisReport." + PreAnalysisReport.labels[PreAnalysisReport.subgroupsPreAnalysis] + ".name")) + ": ");
                analisiDaFare.add(new PreAnalysisReport(this.preanalysis, PreAnalysisReport.subgroupsPreAnalysis, this.getIApplicationManager()));
                this.progressBarPanel.report.append("OK");
            }
            catch (AnalysisException ex) {
                this.progressBarPanel.report.append(" Failed (" + ex.getMessage() + ")");
                this.progressBarPanel.someErrors = true;
            }
        }
        this.updateBar(25);
        if (!filter.isCombineComparisons()) {
            try {
                this.progressBarPanel.report.append("\n " + NbBundle.getMessage(PreAnalysisReport.class, (String)("PreAnalysisReport." + PreAnalysisReport.labels[PreAnalysisReport.comparisonsPreAnalysis] + ".name")) + ": ");
                analisiDaFare.add(new PreAnalysisReport(this.preanalysis, PreAnalysisReport.comparisonsPreAnalysis, this.getIApplicationManager()));
                this.progressBarPanel.report.append("OK");
            }
            catch (AnalysisException ex) {
                this.progressBarPanel.report.append(" Failed (" + ex.getMessage() + ")");
                this.progressBarPanel.someErrors = true;
            }
        }
        this.updateBar(50);
        if (!filter.isCombineTimepoints()) {
            try {
                this.progressBarPanel.report.append("\n " + NbBundle.getMessage(PreAnalysisReport.class, (String)("PreAnalysisReport." + PreAnalysisReport.labels[PreAnalysisReport.timepointsPreAnalysis] + ".name")) + ": ");
                analisiDaFare.add(new PreAnalysisReport(this.preanalysis, PreAnalysisReport.timepointsPreAnalysis, this.getIApplicationManager()));
                this.progressBarPanel.report.append("OK");
            }
            catch (AnalysisException ex) {
                this.progressBarPanel.report.append(" Failed (" + ex.getMessage() + ")");
                this.progressBarPanel.someErrors = true;
            }
        }
        this.updateBar(75);
        if (!filter.isCombineOutcomes()) {
            try {
                this.progressBarPanel.report.append("\n " + NbBundle.getMessage(PreAnalysisReport.class, (String)("PreAnalysisReport." + PreAnalysisReport.labels[PreAnalysisReport.outcomesPreAnalysis] + ".name")) + ": ");
                analisiDaFare.add(new PreAnalysisReport(this.preanalysis, PreAnalysisReport.outcomesPreAnalysis, this.getIApplicationManager()));
                this.progressBarPanel.report.append("OK");
            }
            catch (AnalysisException ex) {
                this.progressBarPanel.report.append(" Failed (" + ex.getMessage() + ")");
                this.progressBarPanel.someErrors = true;
            }
        }
        this.updateBar(100);
        this.progressBarPanel.finito();
        if (!this.progressBarPanel.someErrors) {
            this.frame.dispose();
        }
        this.iApplicationManager.setApplicationEvent((IApplicationEvent)new PreAnalysisDoneEvent(this.preanalysis, analisiDaFare));
    }

    private void updateBar(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreAnalysisRunner.this.progressBarPanel.progressBar.setValue(value);
            }
        });
    }

    public Preanalysis getPreanalysis() {
        return this.preanalysis;
    }
}

