/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.analysis.models.events.ProjectAnalysisDoneEvent;
import metaanalysis.core.analysis.impl.AAnalysisRunner;
import metaanalysis.core.analysis.impl.ModeratorNumericalReport;
import metaanalysis.core.analysis.impl.ModeratorReport;
import metaanalysis.core.analysis.impl.ModeratorrecodeReport;
import metaanalysis.core.analysis.impl.PublicationBiasReport;
import metaanalysis.core.analysis.impl.SummaryReport;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Project;
import metaanalysis.events.models.IApplicationEvent;

public class ProjectAnalysisRunner
extends AAnalysisRunner
implements Runnable {
    private List<Project> projects;

    public ProjectAnalysisRunner(IApplicationManager iApplicationManager, List<Project> projects) {
        super(iApplicationManager);
        this.projects = projects;
    }

    public ProjectAnalysisRunner(IApplicationManager iApplicationManager, Project project) {
        this(iApplicationManager, new ArrayList<Project>());
        this.projects.add(project);
    }

    public ProjectAnalysisRunner(IApplicationManager iApplicationManager, long topicId) {
        this(iApplicationManager, iApplicationManager.getIDataFunction().getAllProjectsOfTopic(topicId));
    }

    @Override
    public void run() {
        this.updateBar(0);
        int space = 100 / this.projects.size();
        int last = 0;
        for (Project project : this.projects) {
            this.runSingle(project, last, last + space);
            last += space;
        }
        this.updateBar(100);
        this.progressBarPanel.finito();
        if (!this.progressBarPanel.someErrors) {
            this.frame.dispose();
        }
    }

    public void runSingle(Project project, int progressBarStart, int progressBarEnd) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.updateBar(progressBarStart);
        int last = progressBarStart;
        int space = progressBarEnd - progressBarStart;
        this.progressBarPanel.report.append(" -- Project: " + project.getName() + " --\n\n");
        try {
            this.progressBarPanel.report.append("Summary Statistic... ");
            list.add(new SummaryReport(project, this.iApplicationManager));
            this.progressBarPanel.report.append("OK\n");
        }
        catch (Exception ex) {
            this.progressBarPanel.report.append(" Failed \n" + ex.getMessage() + "\n\n");
            this.progressBarPanel.someErrors = true;
        }
        last = progressBarStart + space / 5;
        this.updateBar(last);
        AnalysisFilter readAnalysisFilter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        List allModeratorsOfTopic = this.iApplicationManager.getIDataFunction().getAllModeratorsOfTopic(project.getTopicId().longValue());
        int size = allModeratorsOfTopic.size();
        if (size == 0) {
            size = 1;
        }
        int step = space / 10 * 6 / size;
        for (Moderator m : allModeratorsOfTopic) {
            this.progressBarPanel.report.append("\nModerator - " + m.getName() + "... ");
            if (readAnalysisFilter.getExcludedModerators().contains(m.getId())) {
                this.progressBarPanel.report.append("Exluded\n");
            } else {
                try {
                    if (m.getModeratortype() == Moderator.categoricalType && !readAnalysisFilter.getExcludedModerators().contains(m.getId())) {
                        list.add(new ModeratorReport(project, this.iApplicationManager, m, this.iApplicationManager.getMyNumberFormatter()));
                    } else if (m.getModeratortype() == Moderator.continuousType || m.getModeratortype() == Moderator.integerType) {
                        list.add(new ModeratorNumericalReport(project, this.iApplicationManager, m));
                    }
                    this.progressBarPanel.report.append("OK\n");
                }
                catch (Exception ex) {
                    this.progressBarPanel.report.append(" Failed (" + ex.getMessage() + ")\n");
                    this.progressBarPanel.someErrors = true;
                }
            }
            for (Moderatorrecode mr : this.iApplicationManager.getIDataFunction().getAllModeratorrecodeOfModerator(m.getId())) {
                this.progressBarPanel.report.append(":: Recoded moderator - " + mr.getName() + "... ");
                if (!readAnalysisFilter.getExcludedRecodedModerators().contains(mr.getId())) {
                    try {
                        list.add(new ModeratorrecodeReport(project, this.iApplicationManager, mr, this.iApplicationManager.getMyNumberFormatter()));
                        this.progressBarPanel.report.append("OK\n");
                    }
                    catch (Exception ex) {
                        this.progressBarPanel.report.append(" Failed (" + ex.getMessage() + ")\n");
                        ex.printStackTrace();
                        this.progressBarPanel.someErrors = true;
                    }
                    continue;
                }
                this.progressBarPanel.report.append("Exluded\n");
            }
            this.updateBar(last += step);
        }
        try {
            this.progressBarPanel.report.append("\nPublication Bias... ");
            list.add(new PublicationBiasReport(project, this.iApplicationManager));
            this.progressBarPanel.report.append("OK\n");
        }
        catch (Exception ex) {
            this.progressBarPanel.report.append(" Failed (" + ex.getMessage() + ")\n");
            this.progressBarPanel.someErrors = true;
        }
        this.progressBarPanel.report.append("\n\n\n");
        this.updateBar(progressBarEnd);
        this.iApplicationManager.setApplicationEvent((IApplicationEvent)new ProjectAnalysisDoneEvent(project, list));
    }

    private void updateBar(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectAnalysisRunner.this.progressBarPanel.progressBar.setValue(value);
            }
        });
    }

    public List<Project> getProjects() {
        return this.projects;
    }
}

