/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import formattazione.numeri.MyNumberFormatter;
import java.util.ArrayList;
import java.util.List;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.core.analysis.beggspublicationbias.BeggsAnalysis;
import metaanalysis.core.analysis.eggerpublicationpias.EggerAnalysis;
import metaanalysis.core.analysis.failsafenpublicationbias.FailSafeNAnalysis;
import metaanalysis.core.analysis.impl.AAnalysis;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillFixedAnalysis;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillRandomAnalysis;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Project;
import org.openide.util.NbBundle;

public class PublicationBiasAnalysis
extends AAnalysis {
    private TrimAndFillFixedAnalysis trimAndFillFixedAnalysis = null;
    private TrimAndFillRandomAnalysis trimAndFillRandomAnalysis = null;
    private AnalysisFilter filter;
    private BeggsAnalysis beggsAnalysis;
    private FailSafeNAnalysis failSafeNAnalysis;
    private EggerAnalysis eggerAnalysis;
    private MyNumberFormatter myNumberFormatter;

    public PublicationBiasAnalysis(Project project, IApplicationManager applicationEventWorker) throws AnalysisException {
        super(NbBundle.getMessage(AAnalysis.class, (String)"PublicationBias.name"), project, applicationEventWorker);
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        this.filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        this.run();
    }

    public PublicationBiasAnalysis(String name, List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval, MyNumberFormatter myNumberFormatter) throws AnalysisException {
        super(name, rows, pressEffectSizeType, confidenceInterval);
        this.myNumberFormatter = myNumberFormatter;
        this.run();
    }

    private void run() throws AnalysisException {
        ArrayList<AnalysisDataBean> failSafeRows = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean analysisDataBean : this.getDatarows()) {
            failSafeRows.add(analysisDataBean.duplicate());
        }
        this.failSafeNAnalysis = new FailSafeNAnalysis(failSafeRows, this.pressEffectSizeType, this.getConfidenceInterval());
        ArrayList<AnalysisDataBean> eggerRows = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean analysisDataBean : this.getDatarows()) {
            eggerRows.add(analysisDataBean.duplicate());
        }
        this.eggerAnalysis = new EggerAnalysis(eggerRows, this.pressEffectSizeType, this.getConfidenceInterval(), this.myNumberFormatter);
        ArrayList<AnalysisDataBean> arrayList = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean analysisDataBean : this.getDatarows()) {
            arrayList.add(analysisDataBean.duplicate());
        }
        this.beggsAnalysis = new BeggsAnalysis(arrayList, this.pressEffectSizeType, this.getConfidenceInterval(), this.myNumberFormatter);
        ArrayList<AnalysisDataBean> arrayList2 = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean tmp : this.getDatarows()) {
            arrayList2.add(tmp.duplicate());
        }
        this.trimAndFillFixedAnalysis = new TrimAndFillFixedAnalysis(arrayList2, this.pressEffectSizeType, this.getConfidenceInterval(), this.filter.getPublicationBiasSearch());
        ArrayList<AnalysisDataBean> arrayList3 = new ArrayList<AnalysisDataBean>();
        for (AnalysisDataBean tmp : this.getDatarows()) {
            arrayList3.add(tmp.duplicate());
        }
        this.trimAndFillRandomAnalysis = new TrimAndFillRandomAnalysis(arrayList3, this.pressEffectSizeType, this.getConfidenceInterval(), this.filter.getPublicationBiasSearch());
    }

    public TrimAndFillFixedAnalysis getTrimAndFillFixedAnalysis() {
        return this.trimAndFillFixedAnalysis;
    }

    public TrimAndFillRandomAnalysis getTrimAndFillRandomAnalysis() {
        return this.trimAndFillRandomAnalysis;
    }

    public BeggsAnalysis getBeggsAnalysis() {
        return this.beggsAnalysis;
    }

    public FailSafeNAnalysis getFailSafeNAnalysis() {
        return this.failSafeNAnalysis;
    }

    public EggerAnalysis getEggerAnalysis() {
        return this.eggerAnalysis;
    }
}

