/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.application.style.BigTitleFullSize;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanSampleSizeComparator;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanSampleSizeReverseComparator;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.PublicationBiasAnalysis;
import metaanalysis.core.analysis.panels.CumulativeAnalysisPanel;
import metaanalysis.core.analysis.panels.TitleSapce;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Project;
import org.openide.util.NbBundle;

public class PublicationBiasReport
implements IAnalysis {
    JPanel gui = new JPanel();
    private boolean fixedModel = true;
    private boolean randomModel = true;

    public PublicationBiasReport(Project project, IApplicationManager applicationEventWorker) throws AnalysisException {
        this.gui.setLayout(new BoxLayout(this.gui, 1));
        this.gui.setBackground(StyleProvider.panelBackground);
        this.gui.add((Component)new BigTitleFullSize(NbBundle.getMessage(PublicationBiasReport.class, (String)"PublicationBiasReport.pagetitle"), ""));
        AnalysisFilter filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        PublicationBiasAnalysis analysis = new PublicationBiasAnalysis(project, applicationEventWorker);
        if (filter.isFixedMode()) {
            this.gui.add(analysis.getTrimAndFillFixedAnalysis().getGuiReport(true));
        }
        if (filter.isRandomMode()) {
            this.gui.add(analysis.getTrimAndFillRandomAnalysis().getGuiReport(true));
        }
        this.gui.add(analysis.getEggerAnalysis().getGuiReport(true));
        this.gui.add(analysis.getBeggsAnalysis().getGuiReport(true));
        this.gui.add(analysis.getFailSafeNAnalysis().getGuiReport(true));
        this.gui.add(new TitleSapce(NbBundle.getMessage(PublicationBiasReport.class, (String)"CumulativeAnalysis.name")));
        ArrayList<Comparator<AnalysisDataBean>> tmp = new ArrayList<Comparator<AnalysisDataBean>>();
        tmp.add(new AnalysisDataBeanSampleSizeReverseComparator());
        tmp.add(new AnalysisDataBeanSampleSizeComparator());
        this.gui.add(new CumulativeAnalysisPanel(project, applicationEventWorker, filter.isFixedMode(), filter.isRandomMode(), tmp));
    }

    public JPanel getGuiReport(boolean panelTitle) {
        return this.gui;
    }

    public String getName() {
        return NbBundle.getMessage(PublicationBiasReport.class, (String)"PublicationBias.name");
    }
}

