/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import cip.integrator.CipWidget;
import cip.integrator.ForestPlotInputWrapper;
import forestplot.api.ScaleDataInputErrorException;
import formattazione.numeri.MyNumberFormatter;
import gui.alerts.GuiAlerts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.application.style.BigTitleFullSize;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.HeterogeneityStatistic;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanFixedWeightComparator;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanFixedWeightComparatorReverse;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.analysis.impl.OneStudyRemoveAnalysis;
import metaanalysis.core.analysis.panels.CumulativeAnalysisPanel;
import metaanalysis.core.analysis.panels.TablesGenerator;
import metaanalysis.core.analysis.panels.TitleSapce;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Project;
import org.openide.util.NbBundle;

public class SummaryReport
implements IAnalysis {
    JPanel gui;
    private boolean fixedModel = true;
    private boolean randomModel = true;
    private MyNumberFormatter myNumberFormatter;

    public SummaryReport(Project project, IApplicationManager applicationEventWorker) throws AnalysisException {
        ForestPlotInputWrapper fpiw;
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        FixedAndRandomAnalysis fixedAndRandom = new FixedAndRandomAnalysis(project, applicationEventWorker);
        fixedAndRandom.runFixed();
        fixedAndRandom.calculateFixedResiduals();
        AnalysisFilter filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        this.gui = new JPanel();
        this.gui.setLayout(new BoxLayout(this.gui, 1));
        this.gui.setBackground(StyleProvider.panelBackground);
        this.gui.add((Component)new BigTitleFullSize(NbBundle.getMessage(SummaryReport.class, (String)"SummaryReport.pagetitle")));
        if (filter.isFixedMode()) {
            try {
                fpiw = new ForestPlotInputWrapper(fixedAndRandom, true, filter.getEffectSizeType(), this.myNumberFormatter);
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"FixedAnalysis.name")));
                this.gui.add(new CipWidget(fpiw, true, this.myNumberFormatter));
            }
            catch (ScaleDataInputErrorException ex) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"FixedAnalysis.name")));
            }
            JTable defaultDataEntryFixedTable = TablesGenerator.generateDataTable(fixedAndRandom.datarows, false);
            JPanel tmp = new JPanel(new BorderLayout());
            tmp.add((Component)defaultDataEntryFixedTable.getTableHeader(), "North");
            tmp.add((Component)defaultDataEntryFixedTable, "Center");
            this.gui.add(tmp);
        }
        if (filter.isRandomMode()) {
            fixedAndRandom.runRandom();
            fixedAndRandom.calculateRandomResiduals();
            try {
                fpiw = new ForestPlotInputWrapper(fixedAndRandom, false, filter.getEffectSizeType(), this.myNumberFormatter);
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"RandomAnalysis.name")));
                this.gui.add(new CipWidget(fpiw, true, this.myNumberFormatter));
            }
            catch (ScaleDataInputErrorException ex) {
                this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"RandomAnalysis.name")));
            }
            JTable defaultDataEntryRandomTable = TablesGenerator.generateDataTable(fixedAndRandom.datarows, true);
            JPanel tmp2 = new JPanel(new BorderLayout());
            tmp2.add((Component)defaultDataEntryRandomTable.getTableHeader(), "North");
            tmp2.add((Component)defaultDataEntryRandomTable, "Center");
            this.gui.add(tmp2);
        }
        this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"OverallsAnalysis.name")));
        ArrayList<AnalysisDataBean> xxx = new ArrayList<AnalysisDataBean>();
        if (filter.isFixedMode()) {
            xxx.add(fixedAndRandom.getFixedOverall());
        }
        if (filter.isRandomMode()) {
            xxx.add(fixedAndRandom.getRandomOverall());
        }
        JTable overallsTable = TablesGenerator.generateOverallsTable(xxx);
        JPanel tmp3 = new JPanel(new BorderLayout());
        tmp3.add((Component)overallsTable.getTableHeader(), "North");
        tmp3.add((Component)overallsTable, "Center");
        this.gui.add(tmp3);
        if (fixedAndRandom.getDf() >= 1) {
            ForestPlotInputWrapper fpiw2;
            this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"HeterogeneitySatistic.name")));
            ArrayList<HeterogeneityStatistic> hs = new ArrayList<HeterogeneityStatistic>();
            hs.add(new HeterogeneityStatistic(NbBundle.getMessage(SummaryReport.class, (String)"HeterogeneityRecord.name"), fixedAndRandom));
            JTable heterogeneity = TablesGenerator.getDefaultHeterogeneityStatisticsTable(hs);
            JPanel tmp4 = new JPanel(new BorderLayout());
            tmp4.add((Component)heterogeneity.getTableHeader(), "North");
            tmp4.add((Component)heterogeneity, "Center");
            this.gui.add(tmp4);
            OneStudyRemoveAnalysis osra = new OneStudyRemoveAnalysis(project, applicationEventWorker);
            if (filter.isFixedMode()) {
                try {
                    fpiw2 = new ForestPlotInputWrapper(osra, true, filter.getEffectSizeType(), this.myNumberFormatter);
                    this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"OneStudyRemoveFixedAnalysis.name")));
                    this.gui.add(new CipWidget(fpiw2, true, this.myNumberFormatter));
                }
                catch (ScaleDataInputErrorException ex) {
                    GuiAlerts.whatAnError((String)ex.getMessage());
                    this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"OneStudyRemoveFixedAnalysis.name")));
                }
                JTable osr = TablesGenerator.generateOverallsTable(osra.getFixedRows());
                JPanel tmpOSRFixed = new JPanel(new BorderLayout());
                tmpOSRFixed.add((Component)osr.getTableHeader(), "North");
                tmpOSRFixed.add((Component)osr, "Center");
                this.gui.add(tmpOSRFixed);
            }
            if (filter.isRandomMode()) {
                try {
                    fpiw2 = new ForestPlotInputWrapper(osra, false, filter.getEffectSizeType(), this.myNumberFormatter);
                    this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"OneStudyRemoveRandomAnalysis.name")));
                    this.gui.add(new CipWidget(fpiw2, true, this.myNumberFormatter));
                }
                catch (ScaleDataInputErrorException ex) {
                    GuiAlerts.whatAnError((String)ex.getMessage());
                    this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"OneStudyRemoveRandomAnalysis.name")));
                }
                JTable osrR = TablesGenerator.generateOverallsTable(osra.getRandomRows());
                JPanel tmpOSRRandom = new JPanel(new BorderLayout());
                tmpOSRRandom.add((Component)osrR.getTableHeader(), "North");
                tmpOSRRandom.add((Component)osrR, "Center");
                this.gui.add(tmpOSRRandom);
            }
            this.gui.add(new TitleSapce(NbBundle.getMessage(SummaryReport.class, (String)"CumulativeAnalysis.name")));
            ArrayList<Comparator<AnalysisDataBean>> tmp = new ArrayList<Comparator<AnalysisDataBean>>();
            tmp.add(new AnalysisDataBeanFixedWeightComparatorReverse());
            tmp.add(new AnalysisDataBeanFixedWeightComparator());
            this.gui.add(new CumulativeAnalysisPanel(project, applicationEventWorker, filter.isFixedMode(), filter.isRandomMode(), tmp));
        }
    }

    public JPanel getGuiReport(boolean panelTitle) {
        return this.gui;
    }

    public String getName() {
        return NbBundle.getMessage(SummaryReport.class, (String)"SummaryReport.name");
    }
}

