/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.impl;

import java.util.ArrayList;
import java.util.List;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.core.analysis.SubgroupHeterogeneityStatistic;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.openide.util.Exceptions;

public class qTest2AnovaRandomPooled
extends SubgroupHeterogeneityStatistic {
    private double totalWidthin = 0.0;
    private final List<FixedAndRandomAnalysis> randomStandardAnalysis;

    public qTest2AnovaRandomPooled(String name, List<FixedAndRandomAnalysis> sourceLevelsAnalysis, String pressEffectSizeType, double confidenceInterval) throws AnalysisException {
        super(name);
        this.randomStandardAnalysis = sourceLevelsAnalysis;
        double sommaQi = 0.0;
        double sommaDf = 0.0;
        double sommaC = 0.0;
        ArrayList<AnalysisDataBean> righeGlobali = new ArrayList<AnalysisDataBean>();
        for (FixedAndRandomAnalysis tmp : sourceLevelsAnalysis) {
            sommaQi += tmp.calculateHeterogeneity().getQ();
            sommaDf += (double)tmp.getDf();
            sommaC += tmp.getVariableC();
            for (AnalysisDataBean analysisDataBean : tmp.getDatarows()) {
                righeGlobali.add(analysisDataBean.duplicate());
            }
        }
        double t2Within = (sommaQi - sommaDf) / sommaC;
        if (t2Within < 0.0) {
            t2Within = 0.0;
        }
        for (FixedAndRandomAnalysis fixedAndRandomAnalysis : sourceLevelsAnalysis) {
            fixedAndRandomAnalysis.runRandom(t2Within);
        }
        FixedAndRandomAnalysis globalAnalysis = new FixedAndRandomAnalysis("", righeGlobali, pressEffectSizeType, confidenceInterval);
        globalAnalysis.runFixed();
        globalAnalysis.runRandom(t2Within);
        this.df = sourceLevelsAnalysis.size() - 1;
        for (FixedAndRandomAnalysis row : sourceLevelsAnalysis) {
            this.totalWidthin += row.getVariableQRandom();
        }
        this.q = globalAnalysis.getVariableQRandom() - this.totalWidthin;
        ChiSquaredDistributionImpl chiSquaredDistributionImpl = new ChiSquaredDistributionImpl((double)this.df);
        try {
            this.p = 1.0 - chiSquaredDistributionImpl.cumulativeProbability(this.q);
        }
        catch (MathException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

