/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.panels;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.CumulativeAnalysis;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Project;
import org.openide.util.Exceptions;

public class CumulativeAnalysisPanel
extends JPanel {
    private final JComboBox jComboBox;
    private final Project project;
    private final IApplicationManager applicationEventWorker;
    private JPanel guiReport = null;
    private final boolean fixedModel;
    private final boolean randomModel;
    private AnalysisFilter filter;

    public CumulativeAnalysisPanel(Project project, IApplicationManager applicationEventWorker, boolean fixedModel, boolean randomModel, List<Comparator<AnalysisDataBean>> comparators) throws AnalysisException {
        this.project = project;
        this.applicationEventWorker = applicationEventWorker;
        this.fixedModel = fixedModel;
        this.randomModel = randomModel;
        this.filter = AnalysisFilter.readAnalysisFilter((String)project.getFilter());
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(StyleProvider.panelBackground);
        this.jComboBox = new JComboBox();
        for (Comparator<AnalysisDataBean> cmp : comparators) {
            this.jComboBox.addItem(cmp);
        }
        this.jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CumulativeAnalysisPanel.this.aggiorna();
                }
                catch (AnalysisException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        JPanel xxx = new JPanel();
        xxx.setLayout(new FlowLayout(0));
        xxx.setBackground(StyleProvider.panelBackground);
        xxx.add(this.jComboBox);
        xxx.validate();
        this.add(xxx);
        this.aggiorna();
    }

    private void aggiorna() throws AnalysisException {
        Comparator c = (Comparator)this.jComboBox.getSelectedItem();
        CumulativeAnalysis cumulativeAnalysis = new CumulativeAnalysis(this.project, this.applicationEventWorker, c);
        if (this.guiReport != null) {
            this.remove(this.guiReport);
            this.validate();
        }
        this.guiReport = cumulativeAnalysis.getGuiReport(true, this.fixedModel, this.randomModel, this.filter.getNonEffectLine());
        this.add(this.guiReport);
        this.validate();
    }
}

