/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.panels;

import formattazione.numeri.MyNumberFormatter;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanFixedWeightComparator;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanFixedWeightComparatorReverse;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanNumericalModeratorComparator;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanNumericalModeratorComparatorReverse;
import metaanalysis.core.analysis.comparators.ModeratorComparatorInconsistenceException;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.CumulativeAnalysis;
import metaanalysis.core.persistence.Moderator;
import org.openide.util.Exceptions;

public class CumulativeModeratorAnalysisPanel
extends JPanel {
    private final JComboBox jComboBox;
    private final double confidenceInterval;
    private JPanel guiReport = null;
    private final boolean fixedModel;
    private final boolean randomModel;
    private AnalysisFilter filter;
    private final List<AnalysisDataBean> rows;
    private final String pressEffectSizeType;
    private Moderator moderator;
    private final MyNumberFormatter myNumberFormatter;

    public CumulativeModeratorAnalysisPanel(Moderator moderator, List<AnalysisDataBean> rows, AnalysisFilter filter, MyNumberFormatter myNumberFormatter) throws AnalysisException {
        AnalysisDataBeanNumericalModeratorComparatorReverse analysisDataBeanNumericalModeratorComparatorReverse;
        AnalysisDataBeanNumericalModeratorComparator analysisDataBeanNumericalModeratorComparator;
        this.myNumberFormatter = myNumberFormatter;
        this.confidenceInterval = filter.getConfidenceInterval();
        this.rows = rows;
        this.moderator = moderator;
        this.pressEffectSizeType = filter.getEffectSizeType();
        this.filter = filter;
        this.fixedModel = filter.isFixedMode();
        this.randomModel = filter.isRandomMode();
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(StyleProvider.panelBackground);
        try {
            analysisDataBeanNumericalModeratorComparator = new AnalysisDataBeanNumericalModeratorComparator(moderator);
            analysisDataBeanNumericalModeratorComparatorReverse = new AnalysisDataBeanNumericalModeratorComparatorReverse(moderator);
        }
        catch (ModeratorComparatorInconsistenceException ex) {
            throw new AnalysisException("Moderator comparator error");
        }
        this.jComboBox = new JComboBox();
        this.jComboBox.addItem(new AnalysisDataBeanFixedWeightComparator());
        this.jComboBox.addItem(new AnalysisDataBeanFixedWeightComparatorReverse());
        this.jComboBox.addItem(analysisDataBeanNumericalModeratorComparator);
        this.jComboBox.addItem(analysisDataBeanNumericalModeratorComparatorReverse);
        this.jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CumulativeModeratorAnalysisPanel.this.aggiorna();
                }
                catch (AnalysisException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        JPanel xxx = new JPanel();
        xxx.setLayout(new FlowLayout(0));
        xxx.setBackground(StyleProvider.panelBackground);
        xxx.add(this.jComboBox);
        xxx.validate();
        this.add(xxx);
        this.jComboBox.setSelectedItem(analysisDataBeanNumericalModeratorComparator);
        this.aggiorna();
    }

    private void aggiorna() throws AnalysisException {
        Comparator c = (Comparator)this.jComboBox.getSelectedItem();
        CumulativeAnalysis cumulativeAnalysis = new CumulativeAnalysis("Cumulative Analysis", this.rows, this.pressEffectSizeType, this.confidenceInterval, c, this.myNumberFormatter);
        if (this.guiReport != null) {
            this.remove(this.guiReport);
            this.validate();
        }
        this.guiReport = cumulativeAnalysis.getGuiReport(true, this.fixedModel, this.randomModel, this.filter.getNonEffectLine(), this.moderator);
        this.add(this.guiReport);
        this.validate();
    }
}

