/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.panels;

import formattazione.numeri.MyNumberFormatter;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalysis.application.style.LabelsProvider;
import metaanalysis.application.style.StyleProvider;
import org.openide.util.NbBundle;

public class NumericalRegressionPanel
extends JPanel {
    private double slope;
    private double intercept;
    private double pValue;
    private final MyNumberFormatter myNumberFormatter;
    private JTextField interceptField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel kNumberLabel;
    private JLabel pLabel;
    private JTextField pValueField;
    private JTextField slopeField;

    public NumericalRegressionPanel(double sloope, double intercept, double pValue, int k, MyNumberFormatter myNumberFormatter) {
        this.initComponents();
        this.myNumberFormatter = myNumberFormatter;
        this.pLabel.setText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.pvalue"));
        this.pLabel.setToolTipText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.pvalue"));
        this.setBackground(StyleProvider.panelBackground);
        this.slope = sloope;
        this.slopeField.setText(myNumberFormatter.to2d(Double.valueOf(sloope)));
        this.slopeField.setToolTipText(myNumberFormatter.formatInLang(sloope));
        this.intercept = intercept;
        this.interceptField.setText(myNumberFormatter.to2d(Double.valueOf(intercept)));
        this.interceptField.setToolTipText(myNumberFormatter.formatInLang(intercept));
        this.pValue = pValue;
        this.pValueField.setText(myNumberFormatter.to3d(Double.valueOf(pValue)));
        this.pValueField.setToolTipText(myNumberFormatter.formatInLang(pValue));
        this.kNumberLabel.setText("<html><i>k</i>=" + k + "</html>");
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.slopeField = new JTextField();
        this.jLabel3 = new JLabel();
        this.interceptField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.pLabel = new JLabel();
        this.pValueField = new JTextField();
        this.jLabel1 = new JLabel();
        this.kNumberLabel = new JLabel();
        this.jLabel2.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.jLabel2.text"));
        this.slopeField.setEditable(false);
        this.slopeField.setHorizontalAlignment(4);
        this.slopeField.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.slopeField.text"));
        this.slopeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NumericalRegressionPanel.this.slopeFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NumericalRegressionPanel.this.slopeFieldFocusLost(evt);
            }
        });
        this.jLabel3.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.jLabel3.text"));
        this.interceptField.setEditable(false);
        this.interceptField.setHorizontalAlignment(4);
        this.interceptField.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.interceptField.text"));
        this.interceptField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NumericalRegressionPanel.this.interceptFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NumericalRegressionPanel.this.interceptFieldFocusLost(evt);
            }
        });
        this.jLabel4.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.jLabel4.text"));
        this.jLabel5.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.jLabel5.text"));
        this.pLabel.setText("Sig.");
        this.pLabel.setToolTipText("Statistical Significance");
        this.pValueField.setEditable(false);
        this.pValueField.setHorizontalAlignment(4);
        this.pValueField.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.pValueField.text"));
        this.pValueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NumericalRegressionPanel.this.pValueFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NumericalRegressionPanel.this.pValueFieldFocusLost(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.jLabel1.text"));
        this.kNumberLabel.setText(NbBundle.getMessage(NumericalRegressionPanel.class, (String)"NumericalRegressionPanel.kNumberLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.interceptField, -2, 72, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.pValueField, -2, 0, Short.MAX_VALUE).addComponent(this.slopeField, -1, 67, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.kNumberLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.kNumberLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.interceptField, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.slopeField, -2, -1, -2).addComponent(this.jLabel3)).addGap(12, 12, 12).addComponent(this.pLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pValueField, -2, -1, -2).addContainerGap(17, Short.MAX_VALUE)));
    }

    private void slopeFieldFocusGained(FocusEvent evt) {
        this.slopeField.setText(this.myNumberFormatter.formatDouble(Double.valueOf(this.slope), 6));
        this.slopeField.selectAll();
    }

    private void slopeFieldFocusLost(FocusEvent evt) {
        this.slopeField.setText(this.myNumberFormatter.to2d(Double.valueOf(this.slope)));
    }

    private void interceptFieldFocusGained(FocusEvent evt) {
        this.interceptField.setText(this.myNumberFormatter.formatDouble(Double.valueOf(this.intercept), 6));
        this.interceptField.selectAll();
    }

    private void interceptFieldFocusLost(FocusEvent evt) {
        this.interceptField.setText(this.myNumberFormatter.to2d(Double.valueOf(this.intercept)));
    }

    private void pValueFieldFocusGained(FocusEvent evt) {
        this.pValueField.setText(this.myNumberFormatter.formatDouble(Double.valueOf(this.pValue), 6));
        this.pValueField.selectAll();
    }

    private void pValueFieldFocusLost(FocusEvent evt) {
        this.pValueField.setText(this.myNumberFormatter.to3d(Double.valueOf(this.pValue)));
    }
}

