/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.panels;

import java.util.List;
import javax.swing.JTable;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.analysis.HeterogeneityStatistic;
import metaanalysis.core.analysis.SubgroupHeterogeneityStatistic;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.tables.CumulativeModeratorTable;
import metaanalysis.core.analysis.tables.CumulativeModeratorTableModel;
import metaanalysis.core.analysis.tables.DataEntryTable;
import metaanalysis.core.analysis.tables.DataEntryTableModel;
import metaanalysis.core.analysis.tables.HeterogeneityTable;
import metaanalysis.core.analysis.tables.HeterogeneityTableModel;
import metaanalysis.core.analysis.tables.OverallEntryTable;
import metaanalysis.core.analysis.tables.OverallsTableModel;
import metaanalysis.core.analysis.tables.SubgroupHeterogeneityTable;
import metaanalysis.core.analysis.tables.SubgroupHeterogeneityTableModel;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillTable;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillTableModel;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.models.tables.TableFunctions;

public class TablesGenerator {
    public static int moderatorColumnWidth = 60;
    public static int firstColumnWidth = 190;
    public static int pValueColumnWidth = 50;
    public static int effectSizeColumnWidth = 50;
    public static int kColumnWidth = 30;
    public static int sampleSizeColumnWidth = 60;
    public static int weightColumnWidth = 60;
    public static int varianceColumnWidth = 50;

    public static JTable generateDataTable(List<AnalysisDataBean> rows, boolean randomMode) {
        DataEntryTable t = new DataEntryTable(new DataEntryTableModel(rows, randomMode), TuliTuliTools.generateMyNumberFormatter());
        TablesGenerator.showTrick((JTable)((Object)t));
        return t;
    }

    public static JTable generateOverallsTable(List<AnalysisDataBean> rows) {
        OverallEntryTable t = new OverallEntryTable(new OverallsTableModel(rows), TuliTuliTools.generateMyNumberFormatter());
        TablesGenerator.showTrick((JTable)((Object)t));
        return t;
    }

    public static JTable generatePublicationBiasTable(List<AnalysisDataBean> rows) {
        TrimAndFillTable t = new TrimAndFillTable(new TrimAndFillTableModel(rows), TuliTuliTools.generateMyNumberFormatter());
        TablesGenerator.showTrick((JTable)((Object)t));
        return t;
    }

    public static JTable generateModeratorCumulativeTable(List<AnalysisDataBean> rows, Moderator moderator) {
        CumulativeModeratorTable t = new CumulativeModeratorTable(new CumulativeModeratorTableModel(rows, moderator), TuliTuliTools.generateMyNumberFormatter());
        TablesGenerator.showTrick((JTable)((Object)t));
        return t;
    }

    public static JTable getDefaultHeterogeneityStatisticsTable(List<HeterogeneityStatistic> heterogeneityStatitics) {
        HeterogeneityTable t = new HeterogeneityTable(new HeterogeneityTableModel(heterogeneityStatitics), TuliTuliTools.generateMyNumberFormatter());
        TablesGenerator.showTrick((JTable)((Object)t));
        return t;
    }

    public static JTable getDefaultSubgroupHeterogeneityStatisticsTable(List<SubgroupHeterogeneityStatistic> subgroupHeterogeneityStatitics) {
        SubgroupHeterogeneityTable t = new SubgroupHeterogeneityTable(new SubgroupHeterogeneityTableModel(subgroupHeterogeneityStatitics), TuliTuliTools.generateMyNumberFormatter());
        TablesGenerator.showTrick((JTable)((Object)t));
        return t;
    }

    private static void showTrick(JTable t) {
        TableFunctions.showToolTips((JTable)t);
    }
}

