/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.tables;

import java.util.List;
import metaanalysis.application.style.LabelsProvider;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.models.tables.MyAbstractTableModel;
import org.openide.util.NbBundle;

public class DataEntryTableModel
extends MyAbstractTableModel {
    private String[] headers = new String[]{NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.dataentry"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.effectSize"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.lowerLimit"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.upperLimit"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.pvalue"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.variance"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.standarderror"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.weight"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.res"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.pvalueRes"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.globalSS"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.groupASS"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.groupBSS"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.notAssignedSS")};
    private String[] toolType = new String[]{NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.dataentry"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.effectSize"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.lowerLimit"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.upperLimit"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.pvalue"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.variance"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.standarderror"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.weight"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.res"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.pvalueRes"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.globalSS"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.groupASS"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.groupBSS"), NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.notAssignedSS")};
    private List<AnalysisDataBean> rows;
    boolean randomMode = true;

    public String[] getHeaders() {
        return this.headers;
    }

    public String[] getHeadersToolType() {
        return this.toolType;
    }

    public DataEntryTableModel(List<AnalysisDataBean> rows, boolean randomMode) {
        this.rows = rows;
        this.randomMode = randomMode;
    }

    public boolean isRandomMode() {
        return this.randomMode;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public Object getValueAt(int i, int i1) {
        if (i < this.getRowCount()) {
            if (i1 == 0) {
                return this.rows.get(i).getName();
            }
            if (i1 == 1) {
                return this.rows.get(i).getPressEffectSize().getEffectSize();
            }
            if (i1 == 2) {
                return this.rows.get(i).getPressEffectSize().getLowerLimit();
            }
            if (i1 == 3) {
                return this.rows.get(i).getPressEffectSize().getUpperLimit();
            }
            if (i1 == 4) {
                return this.rows.get(i).getPressEffectSize().getPValue();
            }
            if (i1 == 5) {
                return this.rows.get(i).getPressEffectSize().getVariance();
            }
            if (i1 == 6) {
                return this.rows.get(i).getPressEffectSize().getStandardError();
            }
            if (i1 == 7) {
                if (this.isRandomMode()) {
                    return this.rows.get(i).getRandomWeight();
                }
                return this.rows.get(i).getFixedWeight();
            }
            if (i1 == 8) {
                if (this.isRandomMode()) {
                    return this.rows.get(i).getRandomResiduo();
                }
                return this.rows.get(i).getFixedResiduo();
            }
            if (i1 == 9) {
                if (this.isRandomMode()) {
                    return this.rows.get(i).getRandomResiduoPValue();
                }
                return this.rows.get(i).getFixedResiduoPValue();
            }
            if (i1 == 10) {
                return this.rows.get(i).getSampleSize().getSampleSize();
            }
            if (i1 == 11) {
                return this.rows.get(i).getSampleSize().getGroupASize();
            }
            if (i1 == 12) {
                return this.rows.get(i).getSampleSize().getGroupBSize();
            }
            if (i1 == 13) {
                return this.rows.get(i).getSampleSize().getNotSignedSize();
            }
            return null;
        }
        return null;
    }

    public Class<?> getColumnClass(int i) {
        if (i == 1) {
            return Double.class;
        }
        if (i == 2) {
            return Double.class;
        }
        if (i == 3) {
            return Double.class;
        }
        if (i == 4) {
            return Double.class;
        }
        if (i == 5) {
            return Double.class;
        }
        if (i == 6) {
            return Double.class;
        }
        if (i == 7) {
            return Double.class;
        }
        if (i == 8) {
            return Double.class;
        }
        if (i == 9) {
            return Double.class;
        }
        if (i == 10) {
            return Integer.class;
        }
        if (i == 11) {
            return Integer.class;
        }
        if (i == 12) {
            return Integer.class;
        }
        if (i == 13) {
            return Integer.class;
        }
        return String.class;
    }
}

