/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.trimandfillpublicationbias;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.analysis.impl.AAnalysis;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.panels.TablesGenerator;
import metaanalysis.core.analysis.panels.TitleSapce;
import metaanalysis.graph.funnelplot.FunnelPlotGraphInput;
import metaanalysis.graph.funnelplot.FunnelPlotRow;
import org.openide.util.NbBundle;

public abstract class ATrimAndFillAnalysis
extends AAnalysis
implements IAnalysis {
    protected List<AnalysisDataBean> whiteStudies = new ArrayList<AnalysisDataBean>();
    protected List<AnalysisDataBean> blackStudies = new ArrayList<AnalysisDataBean>();
    protected List<AnalysisDataBean> removedStudies = new ArrayList<AnalysisDataBean>();
    protected AnalysisDataBean overallNero;
    protected AnalysisDataBean overallBianco;
    protected List<AnalysisDataBean> overalls = new ArrayList<AnalysisDataBean>();
    protected int lzero = 0;
    protected int sideSearch = 0;

    public AnalysisDataBean getOverallNormale() {
        return this.overallBianco;
    }

    public AnalysisDataBean getOverallNero() {
        return this.overallNero;
    }

    public ATrimAndFillAnalysis(String name, List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval, int sideSearch) throws AnalysisException {
        super(name, rows, pressEffectSizeType, confidenceInterval);
        this.sideSearch = sideSearch;
        if (this.df < 2) {
            throw new AnalysisException(this.name + ": " + NbBundle.getMessage(AAnalysis.class, (String)"Error.pochiStudi", (Object)(this.df + 1)));
        }
    }

    public abstract JPanel getGuiReport(boolean var1);

    public int getLzero() {
        return this.lzero;
    }

    public List<AnalysisDataBean> getOveralls() {
        return this.overalls;
    }

    public List<AnalysisDataBean> getRemovedStudies() {
        return this.removedStudies;
    }

    protected JPanel getReport(boolean panelTitle, String pageTitle) {
        JPanel xxx = new JPanel();
        xxx.setLayout(new BoxLayout(xxx, 1));
        xxx.setBackground(StyleProvider.panelBackground);
        if (panelTitle) {
            ArrayList<FunnelPlotRow> righe = new ArrayList<FunnelPlotRow>();
            for (AnalysisDataBean row : this.whiteStudies) {
                righe.add(new FunnelPlotRow(row.getName(), row.getCalculationEffectSize().getEffectSize(), row.getCalculationEffectSize().getStandardError(), row.getCalculationEffectSize().getLowerLimit(), row.getCalculationEffectSize().getUpperLimit(), FunnelPlotRow.studyType));
            }
            for (AnalysisDataBean row : this.blackStudies) {
                righe.add(new FunnelPlotRow(row.getName(), row.getCalculationEffectSize().getEffectSize(), row.getCalculationEffectSize().getStandardError(), row.getCalculationEffectSize().getLowerLimit(), row.getCalculationEffectSize().getUpperLimit(), FunnelPlotRow.studyBlackType));
            }
            righe.add(new FunnelPlotRow(this.overallBianco.getName(), this.overallBianco.getCalculationEffectSize().getEffectSize(), this.overallBianco.getCalculationEffectSize().getStandardError(), this.overallBianco.getCalculationEffectSize().getLowerLimit(), this.overallBianco.getCalculationEffectSize().getUpperLimit(), FunnelPlotRow.overallType));
            righe.add(new FunnelPlotRow(this.overallNero.getName(), this.overallNero.getCalculationEffectSize().getEffectSize(), this.overallNero.getCalculationEffectSize().getStandardError(), this.overallNero.getCalculationEffectSize().getLowerLimit(), this.overallNero.getCalculationEffectSize().getUpperLimit(), FunnelPlotRow.overallBlackType));
            FunnelPlotGraphInput funnelPlotGraphInput = new FunnelPlotGraphInput("Plot", righe);
            xxx.add(new TitleSapce(pageTitle, funnelPlotGraphInput));
        }
        JTable t = TablesGenerator.generatePublicationBiasTable(this.overalls);
        JPanel tmp = new JPanel(new BorderLayout());
        tmp.add((Component)t.getTableHeader(), "North");
        tmp.add((Component)t, "Center");
        xxx.add(tmp);
        JLabel studiRimossi = new JLabel();
        studiRimossi.setText(NbBundle.getMessage(ATrimAndFillAnalysis.class, (String)"ATrimAndFillAnalysis.trimmedstudies.label", (Object)this.lzero));
        String ttt = "<html>";
        for (AnalysisDataBean row : this.blackStudies) {
            ttt = ttt + "  *" + row.getName() + "<br/>";
        }
        studiRimossi.setToolTipText(ttt + "</html>");
        xxx.add(studiRimossi);
        return xxx;
    }
}

