/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.trimandfillpublicationbias;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillDataRow;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillDataRowAbsoluteDifferenceComparator;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillDataRowRankComparator;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillDataRowRankReverseComparator;

public abstract class ATrimAndFillIteration {
    private int lzero = 0;
    private int srank = 0;
    private final List<AnalysisDataBean> analysisRows = new ArrayList<AnalysisDataBean>();
    private List<TrimAndFillDataRow> trimAndFillDataRows = new ArrayList<TrimAndFillDataRow>();
    private AnalysisDataBean overall;
    private List<AnalysisDataBean> studiesToRemove = new ArrayList<AnalysisDataBean>();
    protected final String pressEffectSizeType;
    protected final double confidenceInterval;
    protected int sideSearch;

    public int getSrank() {
        return this.srank;
    }

    public int getLzero() {
        return this.lzero;
    }

    public ATrimAndFillIteration(List<AnalysisDataBean> startingAnalysisRows, List<AnalysisDataBean> removedAnalysisRows, String pressEffectSizeType, double confidenceInterval, int sideSearch) throws AnalysisException {
        this.sideSearch = sideSearch;
        this.pressEffectSizeType = pressEffectSizeType;
        this.confidenceInterval = confidenceInterval;
        for (AnalysisDataBean row : startingAnalysisRows) {
            this.trimAndFillDataRows.add(new TrimAndFillDataRow(row));
            if (removedAnalysisRows.contains(row)) continue;
            this.analysisRows.add(row);
        }
        this.elabora();
    }

    public int getSideSearch() {
        return this.sideSearch;
    }

    public List<AnalysisDataBean> getAnalysisRows() {
        return this.analysisRows;
    }

    public List<TrimAndFillDataRow> getTrimAndFillDataRows() {
        return this.trimAndFillDataRows;
    }

    protected abstract AnalysisDataBean calculateOverall() throws AnalysisException;

    private void elabora() throws AnalysisException {
        this.overall = this.calculateOverall();
        for (TrimAndFillDataRow row : this.trimAndFillDataRows) {
            Double effectSize = row.getDataEntryRow().getCalculationEffectSize().getEffectSize();
            Double effectSize1 = this.overall.getCalculationEffectSize().getEffectSize();
            row.setDifference(effectSize - effectSize1);
        }
        Collections.sort(this.trimAndFillDataRows, new TrimAndFillDataRowAbsoluteDifferenceComparator());
        for (int i = 0; i < this.trimAndFillDataRows.size(); ++i) {
            this.trimAndFillDataRows.get(i).setRank(i + 1);
        }
        for (TrimAndFillDataRow row : this.trimAndFillDataRows) {
            if (!(row.getDifference() < 0.0)) continue;
            row.setRank(-1.0 * row.getRank());
        }
        if (this.sideSearch == AnalysisFilter.leftSideSearch) {
            for (TrimAndFillDataRow row : this.trimAndFillDataRows) {
                if (!(row.getRank() > 0.0)) continue;
                this.srank = (int)((double)this.srank + row.getRank());
            }
        } else {
            for (TrimAndFillDataRow row : this.trimAndFillDataRows) {
                if (!(row.getRank() < 0.0)) continue;
                this.srank = (int)((double)this.srank + row.getRank());
            }
        }
        this.srank = Math.abs(this.srank);
        double numeratore = 4 * this.srank - this.trimAndFillDataRows.size() * (this.trimAndFillDataRows.size() + 1);
        double denumeratore = 2 * this.trimAndFillDataRows.size() - 1;
        float tmp = (float)(numeratore / denumeratore);
        this.lzero = Math.round(tmp);
        if (this.lzero < 0) {
            this.lzero = 0;
        }
        if (this.sideSearch == AnalysisFilter.leftSideSearch) {
            Collections.sort(this.trimAndFillDataRows, new TrimAndFillDataRowRankReverseComparator());
        } else {
            Collections.sort(this.trimAndFillDataRows, new TrimAndFillDataRowRankComparator());
        }
        for (int i = 0; i < this.lzero; ++i) {
            this.studiesToRemove.add(this.trimAndFillDataRows.get(i).getDataEntryRow());
        }
    }

    public List<AnalysisDataBean> getStudiesToRemove() {
        return this.studiesToRemove;
    }

    public AnalysisDataBean getOverall() {
        return this.overall;
    }
}

