/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.analysis.trimandfillpublicationbias;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import metaanalysis.analysis.models.AnalysisException;
import metaanalysis.analysis.models.IAnalysis;
import metaanalysis.core.analysis.comparators.AnalysisDataBeanEffectSizeComparator;
import metaanalysis.core.analysis.impl.AnalysisDataBean;
import metaanalysis.core.analysis.impl.FixedAndRandomAnalysis;
import metaanalysis.core.analysis.trimandfillpublicationbias.ATrimAndFillAnalysis;
import metaanalysis.core.analysis.trimandfillpublicationbias.TrimAndFillFixedIteration;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import org.openide.util.NbBundle;

public class TrimAndFillFixedAnalysis
extends ATrimAndFillAnalysis
implements IAnalysis {
    public TrimAndFillFixedAnalysis(List<AnalysisDataBean> rows, String pressEffectSizeType, double confidenceInterval, int sideSearch) throws AnalysisException {
        super(NbBundle.getMessage(TrimAndFillFixedAnalysis.class, (String)"analysis.trimandfillFixed.name"), rows, pressEffectSizeType, confidenceInterval, sideSearch);
        FixedAndRandomAnalysis an = new FixedAndRandomAnalysis("", rows, pressEffectSizeType, confidenceInterval);
        an.runFixed();
        this.overallBianco = an.getFixedOverall().duplicate();
        this.overallBianco.setName(NbBundle.getMessage(TrimAndFillFixedAnalysis.class, (String)"analysis.trimandFill.observedLabel"));
        this.whiteStudies.addAll(rows);
        int lzeroVecchio = -1;
        int srankVecchio = -2;
        Collections.sort(this.getDatarows(), new AnalysisDataBeanEffectSizeComparator());
        TrimAndFillFixedIteration trim = new TrimAndFillFixedIteration(this.getDatarows(), this.removedStudies, pressEffectSizeType, confidenceInterval, this.sideSearch);
        this.lzero = trim.getLzero();
        int srankNuovo = trim.getSrank();
        this.removedStudies = trim.getStudiesToRemove();
        int i = 0;
        while (lzeroVecchio != this.lzero && srankNuovo != srankVecchio) {
            if (++i > 50) {
                throw new AnalysisException("Trim and feel loop");
            }
            lzeroVecchio = this.lzero;
            srankVecchio = srankNuovo;
            trim = new TrimAndFillFixedIteration(this.getDatarows(), this.removedStudies, pressEffectSizeType, confidenceInterval, this.sideSearch);
            this.lzero = trim.getLzero();
            srankNuovo = trim.getSrank();
            this.removedStudies = trim.getStudiesToRemove();
        }
        for (AnalysisDataBean row : this.removedStudies) {
            IEffectSizeResults simmetric = row.getCalculationEffectSize().getSimmetric(trim.getOverall().getCalculationEffectSize().getEffectSize().doubleValue(), confidenceInterval);
            AnalysisDataBean der = row.duplicate();
            der.setName("Estimated value: " + der.getName());
            row.setName(der.getName());
            der.setCalculationEffectSize(simmetric);
            der.pressConversion(confidenceInterval);
            der.setSampleSize(row.getSampleSize());
            this.blackStudies.add(der);
        }
        ArrayList<AnalysisDataBean> allStudies = new ArrayList<AnalysisDataBean>();
        allStudies.addAll(this.whiteStudies);
        allStudies.addAll(this.blackStudies);
        FixedAndRandomAnalysis analisiBiancaENera = new FixedAndRandomAnalysis("Estimated Overall", allStudies, pressEffectSizeType, confidenceInterval);
        analisiBiancaENera.runFixed();
        analisiBiancaENera.getFixedOverall().setName(NbBundle.getMessage(TrimAndFillFixedAnalysis.class, (String)"analysis.trimandFill.estimatedLabel"));
        this.overallNero = analisiBiancaENera.getFixedOverall();
        this.overalls.add(this.overallBianco);
        this.overalls.add(this.overallNero);
    }

    @Override
    public JPanel getGuiReport(boolean panelTitle) {
        return this.getReport(panelTitle, NbBundle.getMessage(TrimAndFillFixedAnalysis.class, (String)"analysis.trimandfillFixed.name"));
    }
}

