/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.correlation;

import effectsizeplot.api.AEffectSizeEditorPanel;
import effectsizeplot.input.correlation.CorrelationESSourceBean;
import effectsizeplot.input.correlation.CorrelationEffectSizeTable;
import effectsizeplot.input.correlation.CorrelationEffectSizeTableModel;
import formattazione.numeri.MyNumberFormatter;
import internovi.numbers.locale.provider.LocaleNumbersProvider;
import internovi.statisticaloptions.provider.StatisticalOptionProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CorrelationESPanel
extends AEffectSizeEditorPanel
implements TableModelListener {
    CorrelationESSourceBean bean;
    private final MyNumberFormatter myNumberFormatter;
    private JLabel jLabel1;
    public JComboBox scalaDaUsare;
    public JPanel tabella;

    public CorrelationESPanel(final CorrelationESSourceBean bean) {
        this.initComponents();
        this.bean = bean;
        this.myNumberFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        this.scalaDaUsare.removeAllItems();
        this.scalaDaUsare.addItem(NbBundle.getMessage(CorrelationESSourceBean.class, (String)"scale.linear.name"));
        this.scalaDaUsare.addItem(NbBundle.getMessage(CorrelationESSourceBean.class, (String)"scale.fisher.name"));
        if (bean.getTipoDiScala() != null) {
            this.scalaDaUsare.setSelectedItem(bean.getTipoDiScala());
        }
        this.scalaDaUsare.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                bean.setTipoDiScala(CorrelationESPanel.this.scalaDaUsare.getSelectedItem().toString());
                CorrelationESPanel.this.setModifyTime(new Date().getTime());
            }
        });
        CorrelationEffectSizeTable table = new CorrelationEffectSizeTable(new CorrelationEffectSizeTableModel(bean));
        JPanel tmp = new JPanel(new BorderLayout());
        tmp.add((Component)table.getTableHeader(), "North");
        tmp.add((Component)((Object)table), "Center");
        this.tabella.add(new JScrollPane((Component)((Object)table)));
        table.getModel().addTableModelListener(this);
    }

    private void initComponents() {
        this.scalaDaUsare = new JComboBox();
        this.tabella = new JPanel();
        this.jLabel1 = new JLabel();
        this.scalaDaUsare.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.tabella.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CorrelationESPanel.class, (String)"CorrelationESPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(83, 83, 83).addComponent(this.scalaDaUsare, -2, -1, -2).addGap(0, 418, Short.MAX_VALUE)).addComponent(this.tabella, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scalaDaUsare, -2, -1, -2).addComponent(this.jLabel1)).addGap(8, 8, 8).addComponent(this.tabella, -1, 253, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        this.setModifyTime(new Date().getTime());
    }
}

