/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.correlation;

import formattazione.numeri.MyNumberFormatter;
import java.io.Serializable;

public class CorrelationESRow
implements Serializable {
    private String name = null;
    private Double correlation;
    private Integer sampleSize = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(Double correlation) {
        this.correlation = correlation;
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public static CorrelationESRow createFromText(String text, MyNumberFormatter myNumberFormatter) {
        CorrelationESRow row = new CorrelationESRow();
        String[] campi = text.split("\t");
        for (int i = 0; i < campi.length; ++i) {
            if (i == 0) {
                row.setName(campi[i]);
            }
            if (i == 1) {
                try {
                    row.setCorrelation(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i != 2) continue;
            try {
                row.setSampleSize(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return row;
    }

    public String toText(MyNumberFormatter myNumberFormatter) {
        return (this.name == null ? "" : this.name) + "\t" + (this.correlation == null ? "" : myNumberFormatter.formatInLang(this.correlation.doubleValue())) + "\t" + (this.sampleSize == null ? "" : myNumberFormatter.formatInLang(this.sampleSize.intValue()));
    }

    public boolean isVoid() {
        return this.name == null && this.correlation == null && this.sampleSize == null;
    }
}

