/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.correlation;

import effectsizeplot.api.AEffectSizeEditorPanel;
import effectsizeplot.api.IEffectSizeSource;
import effectsizeplot.api.ITextImporterExporter;
import effectsizeplot.api.ImportExportTextException;
import effectsizeplot.input.correlation.CorrelationESPanel;
import effectsizeplot.input.correlation.CorrelationESRow;
import forestplot.api.BloccoDiRighe;
import forestplot.api.ColoumnDescripotrsFactory;
import forestplot.api.DataEntryRow;
import forestplot.api.FisherScale;
import forestplot.api.IScale;
import forestplot.api.LinearScale;
import forestplot.api.LogScale;
import forestplot.api.PlotInputData;
import forestplot.api.ScaleDataInputErrorException;
import forestplot.api.VisualizerBean;
import formattazione.numeri.MyNumberFormatter;
import internovi.numbers.locale.provider.LocaleNumbersProvider;
import internovi.statisticaloptions.provider.StatisticalOptionProvider;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.openide.util.NbBundle;

public class CorrelationESSourceBean
implements ITextImporterExporter,
IEffectSizeSource,
Serializable {
    private IScale scale;
    public static int rowsNumber = 100;
    private VisualizerBean visualizerBean = new VisualizerBean();
    private String tipoDiScala = NbBundle.getMessage(CorrelationESSourceBean.class, (String)"scale.fisher.name");
    private CorrelationESRow[] righe = new CorrelationESRow[rowsNumber];
    public static String esName = NbBundle.getMessage(CorrelationESSourceBean.class, (String)"directES.name");

    public CorrelationESSourceBean() {
        for (int i = 0; i < rowsNumber; ++i) {
            this.righe[i] = new CorrelationESRow();
        }
    }

    public VisualizerBean getVisualizerBean() {
        return this.visualizerBean;
    }

    public void setVisualizerBean(VisualizerBean visualizerBean) {
        this.visualizerBean = visualizerBean;
    }

    public String getTipoDiScala() {
        return this.tipoDiScala;
    }

    public void setTipoDiScala(String tipoDiScala) {
        this.tipoDiScala = tipoDiScala;
    }

    public CorrelationESRow[] getRighe() {
        return this.righe;
    }

    public void setRighe(CorrelationESRow[] righe) {
        this.righe = righe;
    }

    public CorrelationESRow getRighe(int index) {
        return this.righe[index];
    }

    public void setRighe(int index, CorrelationESRow newRighe) {
        this.righe[index] = newRighe;
    }

    public void writeToFile(OutputStream os) {
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(os));
        e.writeObject(this);
        e.close();
    }

    public void saveToStream(OutputStream os) {
        this.writeToFile(os);
    }

    public AEffectSizeEditorPanel getEditor() {
        return new CorrelationESPanel(this);
    }

    private double fromZToR(double value) {
        return (Math.pow(Math.E, value * 2.0) - 1.0) / (Math.pow(Math.E, value * 2.0) + 1.0);
    }

    public PlotInputData getPlotInputData() throws ScaleDataInputErrorException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        BloccoDiRighe blocco = new BloccoDiRighe();
        PlotInputData plotInputData = new PlotInputData();
        plotInputData.getBlocchiRighe().add((Object)blocco);
        plotInputData.setColonne(ColoumnDescripotrsFactory.generateEffectSizePlotterDescriptors((MyNumberFormatter)myFormatter));
        for (int i = 0; i < rowsNumber; ++i) {
            try {
                double z = 0.5 * Math.log((1.0 + this.righe[i].getCorrelation()) / (1.0 - this.righe[i].getCorrelation()));
                double v = 1.0 / (1.0 * (double)this.righe[i].getSampleSize().intValue() - 3.0);
                double stdErr = Math.sqrt(v);
                double ll = z - 1.96 * stdErr;
                double ul = z + 1.96 * stdErr;
                DataEntryRow row = new DataEntryRow();
                row.setName(this.righe[i].getName());
                row.setEffectSize(this.righe[i].getCorrelation().doubleValue());
                row.setLowerLimit(Double.valueOf(this.fromZToR(ll)));
                row.setUpperLimit(Double.valueOf(this.fromZToR(ul)));
                row.setSampleSize(this.righe[i].getSampleSize().intValue());
                row.setN1(0);
                row.setN2(0);
                blocco.add((Object)row);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.scale = this.tipoDiScala.equals(NbBundle.getMessage(CorrelationESSourceBean.class, (String)"scale.fisher.name")) ? new FisherScale(plotInputData) : (this.tipoDiScala.equals(NbBundle.getMessage(CorrelationESSourceBean.class, (String)"scale.log.name")) ? new LogScale(plotInputData) : new LinearScale(plotInputData));
        plotInputData.setVisualizerBean(this.visualizerBean);
        plotInputData.setUp();
        return plotInputData;
    }

    public String getEffectSizeTypeName() {
        return esName;
    }

    public void importFromText(String text, boolean append) throws ImportExportTextException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        String testo = "";
        if (append) {
            testo = this.exportToText();
        }
        if (!testo.equals("")) {
            testo = testo + "\n";
        }
        testo = testo + text;
        String[] arr = testo.split("\n");
        for (int r = 0; r < arr.length; ++r) {
            this.righe[r] = CorrelationESRow.createFromText(arr[r], myFormatter);
        }
        for (int k = arr.length; k < rowsNumber; ++k) {
            this.righe[k] = new CorrelationESRow();
        }
    }

    public String exportToText() throws ImportExportTextException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        String ret = "";
        String aCapo = "";
        for (CorrelationESRow x : this.righe) {
            if (x.isVoid()) continue;
            ret = ret + aCapo + x.toText(myFormatter);
            aCapo = "\n";
        }
        return ret;
    }

    public IScale getScale() {
        return this.scale;
    }
}

