/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.actions.models.RemoveComparisonbranchAA;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ComparisonbranchCreatedEvent;
import metaanalysis.core.functionsapi.events.ComparisonbranchDeletedEvent;
import metaanalysis.core.functionsapi.events.ComparisonbranchResurrectionEvent;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.ModeratorvalueId;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class DefineComparisonbranchAA
extends AbstractApplicationAction {
    private final Comparisonbranch comparisonbranch;
    private Subgroupbranch subgroupbranch;
    private IApplicationManager applicationEventWorker;
    private List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();

    public DefineComparisonbranchAA(int comparisonId, Subgroupbranch subgroupbranch, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(DefineComparisonbranchAA.class, (String)"AA.DefineComparisonbranchAA.name"), applicationEventWorker);
        this.subgroupbranch = subgroupbranch;
        this.applicationEventWorker = applicationEventWorker;
        this.comparisonbranch = new Comparisonbranch();
        this.comparisonbranch.setComparisonId(Integer.valueOf(comparisonId));
        this.comparisonbranch.setSubgroupbranchId(Long.valueOf(subgroupbranch.getId()));
        List allComparisonbranchesOfSubgroupbranch = this.getLowLevelFunctions().getAllComparisonbranchesOfSubgroupbranch(subgroupbranch);
        if (allComparisonbranchesOfSubgroupbranch.size() == 1 && ((Comparisonbranch)allComparisonbranchesOfSubgroupbranch.get(0)).getComparisonId() == -1) {
            this.addPostApplicationAction((IApplicationActionModel)new RemoveComparisonbranchAA((Comparisonbranch)allComparisonbranchesOfSubgroupbranch.get(0), applicationEventWorker));
        }
        this.setRunApplicationEvent((IApplicationEvent)new ComparisonbranchCreatedEvent(this.comparisonbranch));
        this.setUndoApplicationEvent((IApplicationEvent)new ComparisonbranchDeletedEvent(this.comparisonbranch));
        this.setRedoApplicationEvent((IApplicationEvent)new ComparisonbranchResurrectionEvent(this.comparisonbranch));
        this.setReady(!this.getLowLevelFunctions().comparisonbranchExist(comparisonId, subgroupbranch.getId()));
    }

    public void runImplementation() {
        this.getLowLevelFunctions().createComparisonbranch(this.comparisonbranch);
        Study studyOfTimepointbranch = this.getLowLevelFunctions().getStudyOfComparisonbranch(this.comparisonbranch.getId());
        List allModeratorLevelsOfStudy = this.getLowLevelFunctions().getAllModeratorLevelsOfStudy(studyOfTimepointbranch.getId());
        for (Moderatorlevel tmp : allModeratorLevelsOfStudy) {
            if (tmp.getModeratorlevel() != Moderatorlevel.comparisonbranchLevel) continue;
            Moderator m = this.getLowLevelFunctions().getModerator(tmp.getId().getModeratorId());
            Moderatorvalue mv = new Moderatorvalue(new ModeratorvalueId(tmp.getId().getModeratorId(), tmp.getId().getStudyId(), this.comparisonbranch.getId()), m.getModeratortype(), null, null, null, "");
            this.getLowLevelFunctions().saveModeratorvalue(mv);
            this.moderatorvalues.add(mv);
        }
    }

    public void redoImplementation() throws CannotRedoException {
        this.getLowLevelFunctions().saveComparisonbranch(this.comparisonbranch);
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
    }

    public void undoImplementation() throws CannotUndoException {
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeComparisonbranch(this.comparisonbranch);
    }
}

