/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorCreatedEvent;
import metaanalysis.core.functionsapi.events.ModeratorDeletedEvent;
import metaanalysis.core.functionsapi.events.ModeratorResurrectionEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.ModeratorlevelId;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.ModeratorvalueId;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class DefineModeratorAA
extends AbstractApplicationAction {
    private final Topic topic;
    int moderatorType;
    List<Moderatorlevel> moderatorlevels = new ArrayList<Moderatorlevel>();
    List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();
    private Moderator newModerator = null;

    public DefineModeratorAA(Topic topic, IApplicationManager applicationEventWorker, int moderatorType, String systemLevel) {
        this(DefineModeratorAA.generateDefaultName(moderatorType), topic, applicationEventWorker, moderatorType, systemLevel);
    }

    public DefineModeratorAA(String name, Topic topic, IApplicationManager applicationEventWorker, int moderatorType, String systemLevel) {
        super(NbBundle.getMessage(DefineModeratorAA.class, (String)"AA.DefineModeratorAA.name"), applicationEventWorker);
        this.moderatorType = moderatorType;
        this.topic = topic;
        this.newModerator = new Moderator();
        this.newModerator.setName(name);
        this.newModerator.setModeratortype(Integer.valueOf(this.moderatorType));
        this.newModerator.setTopicId(Long.valueOf(this.topic.getId()));
        this.newModerator.setSystemlevel(systemLevel);
        this.setRunApplicationEvent((IApplicationEvent)new ModeratorCreatedEvent(this.newModerator));
        this.setUndoApplicationEvent((IApplicationEvent)new ModeratorDeletedEvent(this.newModerator));
        this.setRedoApplicationEvent((IApplicationEvent)new ModeratorResurrectionEvent(this.newModerator));
    }

    public static String generateDefaultName(int moderatorType) {
        String nameApp = "";
        if (moderatorType == Moderator.integerType) {
            nameApp = "Integer";
        }
        if (moderatorType == Moderator.continuousType) {
            nameApp = "Continuous";
        }
        if (moderatorType == Moderator.categoricalType) {
            nameApp = "Categorical";
        }
        return "New " + nameApp + " Moderator";
    }

    public void runImplementation() {
        int id = this.getLowLevelFunctions().createModerator(this.newModerator);
        this.newModerator.setId(id);
        List allStudiesOfTopic = this.getLowLevelFunctions().getAllStudiesOfTopic(this.topic);
        for (Study s : allStudiesOfTopic) {
            Moderatorlevel ml = new Moderatorlevel(new ModeratorlevelId(id, s.getId()), Integer.valueOf(Moderatorlevel.studyLevel));
            this.getLowLevelFunctions().saveModeratorlevel(ml);
            this.moderatorlevels.add(ml);
            Moderatorvalue mv = new Moderatorvalue(new ModeratorvalueId(id, s.getId(), s.getId()), this.newModerator.getModeratortype(), null, null, null, "");
            this.getLowLevelFunctions().saveModeratorvalue(mv);
            this.moderatorvalues.add(mv);
        }
    }

    public void redoImplementation() throws CannotRedoException {
        this.getLowLevelFunctions().saveModerator(this.newModerator);
        for (Moderatorlevel ml : this.moderatorlevels) {
            this.getLowLevelFunctions().saveModeratorlevel(ml);
        }
        for (Moderatorvalue mv : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(mv);
        }
    }

    public void undoImplementation() throws CannotUndoException {
        for (Moderatorlevel ml : this.moderatorlevels) {
            this.getLowLevelFunctions().removeModeratorlevel(ml);
        }
        for (Moderatorvalue mv : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(mv);
        }
        this.getLowLevelFunctions().removeModerator(this.newModerator);
    }
}

