/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.OutcomeCreatedEvent;
import metaanalysis.core.functionsapi.events.OutcomeDeletedEvent;
import metaanalysis.core.functionsapi.events.OutcomeResurrectionEvent;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class DefineOutcomeAA
extends AbstractApplicationAction {
    private final Topic topic;
    private Outcome newOutcome = null;

    public DefineOutcomeAA(Topic topic, IApplicationManager applicationEventWorker) {
        this("New outcome", topic, applicationEventWorker);
    }

    public DefineOutcomeAA(String outcomeName, Topic topic, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(DefineOutcomeAA.class, (String)"AA.DefineOutcomeAA.name"), applicationEventWorker);
        this.topic = topic;
        this.newOutcome = new Outcome();
        this.newOutcome.setName(outcomeName);
        this.newOutcome.setTopicId(Long.valueOf(this.topic.getId()));
        this.newOutcome.setGroupa(NbBundle.getMessage(DefineOutcomeAA.class, (String)"AA.DefaultGroupA.label"));
        this.newOutcome.setGroupb(NbBundle.getMessage(DefineOutcomeAA.class, (String)"AA.DefaultGroupB.label"));
        this.newOutcome.setEvent(NbBundle.getMessage(DefineOutcomeAA.class, (String)"AA.DefaultEvent.label"));
        this.newOutcome.setNonevent(NbBundle.getMessage(DefineOutcomeAA.class, (String)"AA.DefaultNonEvent.label"));
        this.setRunApplicationEvent((IApplicationEvent)new OutcomeCreatedEvent(this.newOutcome));
        this.setUndoApplicationEvent((IApplicationEvent)new OutcomeDeletedEvent(this.newOutcome));
        this.setRedoApplicationEvent((IApplicationEvent)new OutcomeResurrectionEvent(this.newOutcome));
    }

    public void runImplementation() {
        int id = this.getLowLevelFunctions().createOutcome(this.newOutcome);
        this.newOutcome.setId(id);
    }

    public void redoImplementation() throws CannotRedoException {
        this.getLowLevelFunctions().saveOutcome(this.newOutcome);
    }

    public void undoImplementation() throws CannotUndoException {
        this.getLowLevelFunctions().removeOutcome(this.newOutcome);
    }
}

