/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.OutcomebranchCreatedEvent;
import metaanalysis.core.functionsapi.events.OutcomebranchDeletedEvent;
import metaanalysis.core.functionsapi.events.OutcomebranchResurrectionEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.ModeratorvalueId;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class DefineOutcomebranchAA
extends AbstractApplicationAction {
    private final Outcome outcome;
    private final Timepointbranch timepointbranch;
    private List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();
    private Outcomebranch newOutcomebranch = null;

    public DefineOutcomebranchAA(Timepointbranch timepointbranch, Outcome outcome, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(DefineOutcomebranchAA.class, (String)"AA.DefineOutcomebranchAA.name"), applicationEventWorker);
        this.outcome = outcome;
        this.timepointbranch = timepointbranch;
        this.setReady(!this.getLowLevelFunctions().outcomebranchExist(outcome, timepointbranch));
    }

    public void runImplementation() {
        this.newOutcomebranch = new Outcomebranch();
        this.newOutcomebranch.setOutcomeId(Integer.valueOf(this.outcome.getId()));
        this.newOutcomebranch.setTimepointbranchId(Long.valueOf(this.timepointbranch.getId()));
        long createOutcomebranch = this.getLowLevelFunctions().createOutcomebranch(this.newOutcomebranch);
        Study studyOfOutcomebranch = this.getLowLevelFunctions().getStudyOfOutcomebranch(createOutcomebranch);
        List allModeratorLevelsOfStudy = this.getLowLevelFunctions().getAllModeratorLevelsOfStudy(studyOfOutcomebranch.getId());
        for (Moderatorlevel tmp : allModeratorLevelsOfStudy) {
            if (tmp.getModeratorlevel() != Moderatorlevel.outcomebranchLevel) continue;
            Moderator m = this.getLowLevelFunctions().getModerator(tmp.getId().getModeratorId());
            Moderatorvalue mv = new Moderatorvalue(new ModeratorvalueId(tmp.getId().getModeratorId(), tmp.getId().getStudyId(), createOutcomebranch), m.getModeratortype(), null, null, null, "");
            this.getLowLevelFunctions().saveModeratorvalue(mv);
            this.moderatorvalues.add(mv);
        }
        this.launch((IApplicationEvent)new OutcomebranchCreatedEvent(this.newOutcomebranch));
    }

    public void redoImplementation() throws CannotRedoException {
        this.getLowLevelFunctions().saveOutcomebranch(this.newOutcomebranch);
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
        this.launch((IApplicationEvent)new OutcomebranchResurrectionEvent(this.newOutcomebranch));
    }

    public void undoImplementation() throws CannotUndoException {
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeOutcomebranch(this.newOutcomebranch);
        this.launch((IApplicationEvent)new OutcomebranchDeletedEvent(this.newOutcomebranch));
    }
}

