/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.StudyCreatedEvent;
import metaanalysis.core.functionsapi.events.StudyDeletedEvent;
import metaanalysis.core.functionsapi.events.StudyResurrectionEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.ModeratorlevelId;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.ModeratorvalueId;
import metaanalysis.core.persistence.Study;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class DefineStudyAA
extends AbstractApplicationAction {
    private final Study study = new Study();
    private List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();
    private List<Moderatorlevel> moderatorlevels = new ArrayList<Moderatorlevel>();
    private int publicationYear;
    private String publicationType;

    public DefineStudyAA(String studyName, int publicationYear, String publicationType, long topicId, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(DefineStudyAA.class, (String)"AA.DefineStudyAA.name"), applicationEventWorker);
        this.study.setName(studyName);
        this.study.setTopicId(Long.valueOf(topicId));
        this.publicationYear = publicationYear;
        this.publicationType = publicationType;
        this.setRunApplicationEvent((IApplicationEvent)new StudyCreatedEvent(this.study));
        this.setUndoApplicationEvent((IApplicationEvent)new StudyDeletedEvent(this.study));
        this.setRedoApplicationEvent((IApplicationEvent)new StudyResurrectionEvent(this.study));
    }

    public void runImplementation() {
        long createStudy = this.getLowLevelFunctions().createStudy(this.study);
        List allModeratorsOfTopic = this.getLowLevelFunctions().getAllModeratorsOfTopic(this.study.getTopicId().longValue());
        for (Moderator m : allModeratorsOfTopic) {
            Moderatorlevel ml = new Moderatorlevel(new ModeratorlevelId(m.getId(), createStudy), Integer.valueOf(Moderatorlevel.studyLevel));
            this.getLowLevelFunctions().saveModeratorlevel(ml);
            this.moderatorlevels.add(ml);
            Moderatorvalue mv = m.getSystemlevel().equals(Moderator.publicationYearSystemLevel) ? new Moderatorvalue(new ModeratorvalueId(m.getId(), createStudy, createStudy), m.getModeratortype(), null, Integer.valueOf(this.publicationYear), null, "") : (m.getSystemlevel().equals(Moderator.publicationTypeSystemLevel) ? new Moderatorvalue(new ModeratorvalueId(m.getId(), createStudy, createStudy), m.getModeratortype(), this.publicationType, null, null, "") : new Moderatorvalue(new ModeratorvalueId(m.getId(), createStudy, createStudy), m.getModeratortype(), null, null, null, ""));
            this.getLowLevelFunctions().saveModeratorvalue(mv);
            this.moderatorvalues.add(mv);
        }
    }

    public void redoImplementation() throws CannotRedoException {
        this.getLowLevelFunctions().saveStudy(this.study);
        for (Moderatorlevel ml : this.moderatorlevels) {
            this.getLowLevelFunctions().saveModeratorlevel(ml);
        }
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
    }

    public void undoImplementation() throws CannotUndoException {
        for (Moderatorlevel ml : this.moderatorlevels) {
            this.getLowLevelFunctions().removeModeratorlevel(ml);
        }
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeStudy(this.study);
    }
}

