/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.actions.models.RemoveSubgroupbranchAA;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.SubgroupbranchCreatedEvent;
import metaanalysis.core.functionsapi.events.SubgroupbranchDeletedEvent;
import metaanalysis.core.functionsapi.events.SubgroupbranchResurrectionEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.ModeratorvalueId;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class DefineSubgroupbranchAA
extends AbstractApplicationAction {
    private final Subgroupbranch subgroupbranch;
    private Study study;
    private IApplicationManager applicationEventWorker;
    private List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();

    public DefineSubgroupbranchAA(int subgroupId, Study study, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(DefineSubgroupbranchAA.class, (String)"AA.DefineSubgroupbranchAA.name"), applicationEventWorker);
        this.study = study;
        this.applicationEventWorker = applicationEventWorker;
        this.subgroupbranch = new Subgroupbranch();
        this.subgroupbranch.setSubgroupId(Integer.valueOf(subgroupId));
        this.subgroupbranch.setStudyId(Long.valueOf(study.getId()));
        List allSubgroupbranchesOfStudy = this.getLowLevelFunctions().getAllSubgroupbranchesOfStudy(study.getId());
        if (allSubgroupbranchesOfStudy.size() == 1 && ((Subgroupbranch)allSubgroupbranchesOfStudy.get(0)).getSubgroupId() == -1) {
            this.addPostApplicationAction((IApplicationActionModel)new RemoveSubgroupbranchAA((Subgroupbranch)allSubgroupbranchesOfStudy.get(0), applicationEventWorker));
        }
        this.setRunApplicationEvent((IApplicationEvent)new SubgroupbranchCreatedEvent(this.subgroupbranch));
        this.setUndoApplicationEvent((IApplicationEvent)new SubgroupbranchDeletedEvent(this.subgroupbranch));
        this.setRedoApplicationEvent((IApplicationEvent)new SubgroupbranchResurrectionEvent(this.subgroupbranch));
        this.setReady(!this.getLowLevelFunctions().subgroupbranchExist(subgroupId, study.getId()));
    }

    public void runImplementation() {
        this.getLowLevelFunctions().createSubgroupbranch(this.subgroupbranch);
        List allModeratorLevelsOfStudy = this.getLowLevelFunctions().getAllModeratorLevelsOfStudy(this.study.getId());
        for (Moderatorlevel tmp : allModeratorLevelsOfStudy) {
            if (tmp.getModeratorlevel() != Moderatorlevel.subgroupbranchLevel) continue;
            Moderator m = this.getLowLevelFunctions().getModerator(tmp.getId().getModeratorId());
            Moderatorvalue mv = new Moderatorvalue(new ModeratorvalueId(tmp.getId().getModeratorId(), tmp.getId().getStudyId(), this.subgroupbranch.getId()), m.getModeratortype(), null, null, null, "");
            this.getLowLevelFunctions().saveModeratorvalue(mv);
            this.moderatorvalues.add(mv);
        }
    }

    public void redoImplementation() throws CannotRedoException {
        this.getLowLevelFunctions().saveSubgroupbranch(this.subgroupbranch);
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
    }

    public void undoImplementation() throws CannotUndoException {
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeSubgroupbranch(this.subgroupbranch);
    }
}

