/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TimepointbranchCreatedEvent;
import metaanalysis.core.functionsapi.events.TimepointbranchDeletedEvent;
import metaanalysis.core.functionsapi.events.TimepointbranchResurrectionEvent;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.ModeratorvalueId;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class DefineTimepointbranchAA
extends AbstractApplicationAction {
    private final Timepointbranch timepointbranch = new Timepointbranch();
    private List<Moderatorvalue> moderatorvalues = new ArrayList<Moderatorvalue>();

    public DefineTimepointbranchAA(Comparisonbranch comparisonbranch, int timepointId, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(DefineTimepointbranchAA.class, (String)"AA.DefineTimepointbranchAA.name"), applicationEventWorker);
        this.timepointbranch.setComparisonbranchId(Long.valueOf(comparisonbranch.getId()));
        this.timepointbranch.setTimepointId(Integer.valueOf(timepointId));
    }

    public void runImplementation() {
        this.getLowLevelFunctions().createTimepointbranch(this.timepointbranch);
        Study studyOfTimepointbranch = this.getLowLevelFunctions().getStudyOfTimepointbranch(this.timepointbranch.getId());
        List allModeratorLevelsOfStudy = this.getLowLevelFunctions().getAllModeratorLevelsOfStudy(studyOfTimepointbranch.getId());
        for (Moderatorlevel tmp : allModeratorLevelsOfStudy) {
            if (tmp.getModeratorlevel() != Moderatorlevel.timepointbranchLevel) continue;
            Moderator m = this.getLowLevelFunctions().getModerator(tmp.getId().getModeratorId());
            Moderatorvalue mv = new Moderatorvalue(new ModeratorvalueId(tmp.getId().getModeratorId(), tmp.getId().getStudyId(), this.timepointbranch.getId()), m.getModeratortype(), null, null, null, "");
            this.getLowLevelFunctions().saveModeratorvalue(mv);
            this.moderatorvalues.add(mv);
        }
        this.launch((IApplicationEvent)new TimepointbranchCreatedEvent(this.timepointbranch));
    }

    public void redoImplementation() throws CannotRedoException {
        this.getLowLevelFunctions().saveTimepointbranch(this.timepointbranch);
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
        this.launch((IApplicationEvent)new TimepointbranchResurrectionEvent(this.timepointbranch));
    }

    public void undoImplementation() throws CannotUndoException {
        for (Moderatorvalue tmp : this.moderatorvalues) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.getLowLevelFunctions().removeTimepointbranch(this.timepointbranch);
        this.launch((IApplicationEvent)new TimepointbranchDeletedEvent(this.timepointbranch));
    }
}

