/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.actions.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import metaanalysis.core.functionsapi.AbstractApplicationAction;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorValueMovedEvent;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.ModeratorlevelId;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class MoveModeratorValueToOutcomebranchAA
extends AbstractApplicationAction {
    private List<Moderatorvalue> moderatorValuesCreati = new ArrayList<Moderatorvalue>();
    private List<Moderatorvalue> moderatorValueDaEliminare;
    private Moderatorvalue moderatorvalueIniziale;
    private Moderatorlevel moderatorLevel;
    private int livelloIniziale;

    public MoveModeratorValueToOutcomebranchAA(Moderatorvalue moderatorvalue, IApplicationManager applicationEventWorker) {
        super(NbBundle.getMessage(MoveModeratorValueToOutcomebranchAA.class, (String)"AA.UpdateModeratorValueAA.name"), applicationEventWorker);
        this.moderatorvalueIniziale = moderatorvalue;
        this.moderatorValueDaEliminare = applicationEventWorker.getIDataFunction().getAllModeratorValuesOfStudy(this.moderatorvalueIniziale.getId().getStudyId(), this.moderatorvalueIniziale.getId().getModeratorId());
        this.moderatorLevel = applicationEventWorker.getIDataFunction().getModeratorlevel(new ModeratorlevelId(moderatorvalue.getId().getModeratorId(), moderatorvalue.getId().getStudyId()));
        this.livelloIniziale = this.moderatorLevel.getModeratorlevel();
        if (this.moderatorLevel.getModeratorlevel() == Moderatorlevel.outcomebranchLevel) {
            this.setReady(false);
        }
        this.setApplicationEventsAllInOne((IApplicationEvent)new ModeratorValueMovedEvent(this.moderatorvalueIniziale));
    }

    public void runImplementation() {
        List allOutcomebranchsOfStudy = this.getLowLevelFunctions().getAllOutcomebranchsOfStudy(this.moderatorvalueIniziale.getId().getStudyId());
        for (Outcomebranch ob : allOutcomebranchsOfStudy) {
            Moderatorvalue mv = this.moderatorvalueIniziale.duplicate();
            mv.getId().setLongidgenId(ob.getId());
            this.getLowLevelFunctions().saveModeratorvalue(mv);
            this.moderatorValuesCreati.add(mv);
        }
        for (Moderatorvalue tmp : this.moderatorValueDaEliminare) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.moderatorLevel.setModeratorlevel(Integer.valueOf(Moderatorlevel.outcomebranchLevel));
        this.getLowLevelFunctions().saveModeratorlevel(this.moderatorLevel);
    }

    public void redoImplementation() throws CannotRedoException {
        for (Moderatorvalue mv : this.moderatorValuesCreati) {
            this.getLowLevelFunctions().saveModeratorvalue(mv);
        }
        for (Moderatorvalue tmp : this.moderatorValueDaEliminare) {
            this.getLowLevelFunctions().removeModeratorValue(tmp);
        }
        this.moderatorLevel.setModeratorlevel(Integer.valueOf(Moderatorlevel.outcomebranchLevel));
        this.getLowLevelFunctions().saveModeratorlevel(this.moderatorLevel);
    }

    public void undoImplementation() throws CannotUndoException {
        for (Moderatorvalue tmp : this.moderatorValueDaEliminare) {
            this.getLowLevelFunctions().saveModeratorvalue(tmp);
        }
        for (Moderatorvalue mv : this.moderatorValuesCreati) {
            this.getLowLevelFunctions().removeModeratorValue(mv);
        }
        this.moderatorLevel.setModeratorlevel(Integer.valueOf(this.livelloIniziale));
        this.getLowLevelFunctions().saveModeratorlevel(this.moderatorLevel);
    }
}

